/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.xml;

import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.policy.DefaultPolicy;
import org.apache.rat.report.RatReport;
import org.apache.rat.report.analyser.DefaultAnalyserFactory;
import org.apache.rat.report.claim.IClaimReporter;
import org.apache.rat.report.claim.impl.xml.SimpleXmlClaimReporter;
import org.apache.rat.report.claim.util.ClaimReporterMultiplexer;
import org.apache.rat.report.xml.XmlReport;
import org.apache.rat.report.xml.writer.IXmlWriter;

public class XmlReportFactory {
    public static final RatReport createStandardReport(IXmlWriter writer, IHeaderMatcher matcher) {
        return XmlReportFactory.createStandardReport(writer, matcher, null);
    }

    public static final RatReport createStandardReport(IXmlWriter writer, IHeaderMatcher matcher, ILicenseFamily[] approvedLicenses) {
        SimpleXmlClaimReporter reporter = new SimpleXmlClaimReporter(writer);
        DefaultPolicy policy = new DefaultPolicy((IClaimReporter)reporter, approvedLicenses);
        IClaimReporter[] reporters = new IClaimReporter[]{reporter, policy};
        ClaimReporterMultiplexer multiplexer = new ClaimReporterMultiplexer(reporters);
        IDocumentAnalyser analyser = DefaultAnalyserFactory.createDefaultAnalyser(multiplexer, matcher);
        XmlReport result = new XmlReport(writer, analyser);
        return result;
    }
}

