/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.xml;

import java.io.IOException;
import org.apache.rat.document.IDocument;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.report.RatReport;
import org.apache.rat.report.RatReportFailedException;
import org.apache.rat.report.xml.writer.IXmlWriter;

class XmlReport
implements RatReport {
    private final IDocumentAnalyser analyser;
    private final IXmlWriter writer;

    public XmlReport(IXmlWriter writer, IDocumentAnalyser analyser) {
        this.analyser = analyser;
        this.writer = writer;
    }

    public void startReport() throws RatReportFailedException {
        try {
            this.writer.openElement("rat-report");
        }
        catch (IOException e) {
            throw new RatReportFailedException("Cannot open start element", e);
        }
    }

    public void endReport() throws RatReportFailedException {
        try {
            this.writer.closeDocument();
        }
        catch (IOException e) {
            throw new RatReportFailedException("Cannot close last element", e);
        }
    }

    public void report(IDocument document) throws RatReportFailedException {
        try {
            this.analyser.analyse(document);
        }
        catch (RatDocumentAnalysisException e) {
            throw new RatReportFailedException("Analysis failed", (Throwable)((Object)e));
        }
    }
}

