/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.analyser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.rat.analysis.Claims;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.report.RatReportFailedException;
import org.apache.rat.report.claim.IClaimReporter;

class HeaderCheckWorker {
    public static final int DEFAULT_NUMBER_OF_RETAINED_HEADER_LINES = 50;
    private final int numberOfRetainedHeaderLines;
    private final BufferedReader reader;
    private final IHeaderMatcher matcher;
    private final IClaimReporter reporter;
    private final String name;
    private boolean match = false;
    private int headerLinesToRead;
    private boolean finished = false;

    public HeaderCheckWorker(Reader reader, int numberOfRetainedHeaderLine, IHeaderMatcher matcher, IClaimReporter reporter, String name) {
        this(new BufferedReader(reader), numberOfRetainedHeaderLine, matcher, reporter, name);
    }

    public HeaderCheckWorker(Reader reader, IHeaderMatcher matcher, IClaimReporter reporter, String name) {
        this(new BufferedReader(reader), matcher, reporter, name);
    }

    public HeaderCheckWorker(BufferedReader reader, IHeaderMatcher matcher, IClaimReporter reporter, String name) {
        this(reader, 50, matcher, reporter, name);
    }

    public HeaderCheckWorker(BufferedReader reader, int numberOfRetainedHeaderLine, IHeaderMatcher matcher, IClaimReporter reporter, String name) {
        this.reader = reader;
        this.numberOfRetainedHeaderLines = numberOfRetainedHeaderLine;
        this.matcher = matcher;
        this.reporter = reporter;
        this.name = name;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void read() throws RatHeaderAnalysisException {
        if (!this.finished) {
            StringBuffer headers = new StringBuffer();
            this.headerLinesToRead = this.numberOfRetainedHeaderLines;
            try {
                while (this.readLine(headers)) {
                }
                if (!this.match) {
                    String notes = headers.toString();
                    Claims.reportStandardClaims(this.name, notes, "?????", "UNKNOWN", this.reporter);
                }
            }
            catch (IOException e) {
                throw new RatHeaderAnalysisException("Cannot read header for " + this.name, e);
            }
            catch (RatReportFailedException e) {
                throw new RatHeaderAnalysisException("Cannot write claim for " + this.name, (Throwable)((Object)e));
            }
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.matcher.reset();
        }
        this.finished = true;
    }

    boolean readLine(StringBuffer headers) throws IOException, RatHeaderAnalysisException {
        boolean result;
        String line = this.reader.readLine();
        boolean bl = result = line != null;
        if (result) {
            if (this.headerLinesToRead-- > 0) {
                headers.append(line);
                headers.append('\n');
            }
            this.match = this.matcher.match(this.name, line, this.reporter);
            result = !this.match;
        }
        return result;
    }
}

