/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.analyser;

import java.io.IOException;
import java.io.Reader;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.document.IDocument;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.report.analyser.HeaderCheckWorker;
import org.apache.rat.report.claim.IClaimReporter;

public class DocumentHeaderAnalyser
implements IDocumentAnalyser {
    private final IHeaderMatcher matcher;
    private final IClaimReporter reporter;

    public DocumentHeaderAnalyser(IHeaderMatcher matcher, IClaimReporter reporter) {
        this.matcher = matcher;
        this.reporter = reporter;
    }

    public void analyse(IDocument document) throws RatDocumentAnalysisException {
        Reader reader = null;
        try {
            reader = document.reader();
            String name = document.getName();
            HeaderCheckWorker worker = new HeaderCheckWorker(reader, this.matcher, this.reporter, name);
            worker.read();
        }
        catch (IOException e) {
            throw new RatDocumentAnalysisException("Cannot read header", e);
        }
        catch (RatHeaderAnalysisException e) {
            throw new RatDocumentAnalysisException("Cannot analyse header", (Throwable)((Object)e));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

