/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.analyser;

import org.apache.rat.document.IDocument;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.report.RatReportFailedException;
import org.apache.rat.report.analyser.RatReportAnalysisResultException;
import org.apache.rat.report.claim.IClaimReporter;

public abstract class AbstractSingleClaimAnalyser
implements IDocumentAnalyser {
    private final IClaimReporter reporter;
    private final CharSequence predicate;
    private final boolean isLiteral;

    public AbstractSingleClaimAnalyser(IClaimReporter reporter, CharSequence predicate, boolean isLiteral) {
        this.reporter = reporter;
        this.predicate = predicate;
        this.isLiteral = isLiteral;
    }

    public void analyse(IDocument document) throws RatDocumentAnalysisException {
        String name = document.getName();
        try {
            CharSequence object = this.toObject(document);
            this.reporter.claim(name, this.predicate, object, this.isLiteral);
        }
        catch (RatReportFailedException e) {
            throw new RatReportAnalysisResultException(e);
        }
    }

    protected abstract CharSequence toObject(IDocument var1) throws RatDocumentAnalysisException;
}

