/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.policy;

import java.util.Arrays;
import org.apache.rat.analysis.Claims;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.report.RatReportFailedException;
import org.apache.rat.report.claim.IClaimReporter;

public class DefaultPolicy
implements IClaimReporter {
    private static final String[] APPROVED_LICENSES = new String[]{"Apache License Version 2.0", "OASIS Open License", "W3C Software Copyright", "W3C Document Copyright", "Modified BSD License"};
    private final IClaimReporter reporter;
    private final String[] approvedLicenseNames;

    private static final String[] toNames(ILicenseFamily[] approvedLicenses) {
        String[] results = null;
        if (approvedLicenses != null) {
            int length = approvedLicenses.length;
            results = new String[length];
            for (int i = 0; i < length; ++i) {
                results[i] = approvedLicenses[i].getFamilyName();
            }
        }
        return results;
    }

    public DefaultPolicy(IClaimReporter reporter) {
        this(reporter, APPROVED_LICENSES);
    }

    public DefaultPolicy(IClaimReporter reporter, ILicenseFamily[] approvedLicenses) {
        this(reporter, DefaultPolicy.toNames(approvedLicenses));
    }

    public DefaultPolicy(IClaimReporter reporter, String[] approvedLicenseNames) {
        this.reporter = reporter;
        if (approvedLicenseNames == null) {
            this.approvedLicenseNames = APPROVED_LICENSES;
        } else {
            int length = approvedLicenseNames.length;
            this.approvedLicenseNames = new String[length];
            System.arraycopy(approvedLicenseNames, 0, this.approvedLicenseNames, 0, length);
        }
        Arrays.sort(this.approvedLicenseNames);
    }

    public void claim(CharSequence subject, CharSequence predicate, CharSequence object, boolean isLiteral) throws RatReportFailedException {
        if ("license-family".equals(predicate)) {
            boolean isApproved = Arrays.binarySearch(this.approvedLicenseNames, object) >= 0;
            Claims.reportLicenseApprovalClaim(subject, isApproved, this.reporter);
        }
    }
}

