/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document.impl.zip;

import java.util.zip.ZipEntry;

final class ZipUtils {
    ZipUtils() {
    }

    public static String getStem(ZipEntry entry) {
        String name = entry.getName();
        int lastIndexOfForwardSlash = name.lastIndexOf(47);
        int lastIndexOfBackSlash = name.lastIndexOf(92);
        int index = Math.max(lastIndexOfBackSlash, lastIndexOfForwardSlash);
        String result = "";
        if (index >= 0) {
            result = name.substring(0, index);
        }
        return result;
    }

    public static String getName(ZipEntry entry) {
        String name = entry.getName();
        if (name.endsWith("/") || name.endsWith("\\")) {
            name = name.substring(0, name.length() - 1);
        }
        int lastIndexOfForwardSlash = name.lastIndexOf(47);
        int lastIndexOfBackSlash = name.lastIndexOf(92);
        int index = Math.max(lastIndexOfBackSlash, lastIndexOfForwardSlash);
        String result = name;
        if (index >= 0) {
            int length = name.length();
            result = name.substring(index + 1, length);
        }
        return result;
    }

    public static String getUrl(ZipEntry entry) {
        return "zip:" + entry.getName();
    }

    public static boolean isTopLevel(ZipEntry entry) {
        String name = entry.getName();
        int lastPosition = name.length() - 1;
        int indexOfForwardSlash = name.indexOf(47);
        int indexOfBackSlash = name.indexOf(92);
        boolean result = !(indexOfForwardSlash >= 0 && indexOfForwardSlash != lastPosition || indexOfBackSlash >= 0 && indexOfBackSlash != lastPosition);
        return result;
    }
}

