/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document.impl.zip;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.collections.EnumerationUtils;
import org.apache.rat.document.IDocumentCollection;
import org.apache.rat.document.impl.zip.ZipDirectory;
import org.apache.rat.document.impl.zip.ZipDocument;
import org.apache.rat.document.impl.zip.ZipRootDirectory;
import org.apache.rat.document.impl.zip.ZipUtils;

public class ZipDocumentFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IDocumentCollection load(File file) throws IOException {
        ZipFile zip = null;
        try {
            ZipRootDirectory result;
            zip = new ZipFile(file);
            ArrayList<ZipDocument> documents = new ArrayList<ZipDocument>();
            ArrayList<ZipDirectory> subdirectories = new ArrayList<ZipDirectory>();
            ArrayList<ZipDirectory> directories = new ArrayList<ZipDirectory>();
            List entries = EnumerationUtils.toList(zip.entries());
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                ZipEntry entry = (ZipEntry)it.next();
                boolean isDirectory = entry.isDirectory();
                boolean topLevel = ZipUtils.isTopLevel(entry);
                if (isDirectory) {
                    ZipDirectory directory = ZipDocumentFactory.createDirectory(entry, entries, directories, zip);
                    if (topLevel) {
                        subdirectories.add(directory);
                    }
                    directories.add(directory);
                    continue;
                }
                if (!topLevel) continue;
                documents.add(new ZipDocument(entry, zip));
            }
            it = directories.iterator();
            while (it.hasNext()) {
                ZipDirectory directory = (ZipDirectory)it.next();
                directory.addSubDirectories(directories);
            }
            ZipRootDirectory zipRootDirectory = result = new ZipRootDirectory(zip, subdirectories, documents);
            return zipRootDirectory;
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
    }

    private static ZipDirectory createDirectory(ZipEntry entry, List entries, Collection directories, ZipFile zip) {
        String stem = ZipUtils.getStem(entry);
        ArrayList<ZipDirectory> subdirectories = new ArrayList<ZipDirectory>();
        ArrayList<ZipDocument> documents = new ArrayList<ZipDocument>();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            String otherStem;
            ZipEntry otherEntry = (ZipEntry)it.next();
            if (otherEntry.equals(entry) || !stem.equals(otherStem = ZipUtils.getStem(otherEntry))) continue;
            if (otherEntry.isDirectory()) {
                ZipDirectory subDirectory = ZipDocumentFactory.createDirectory(otherEntry, entries, directories, zip);
                subdirectories.add(subDirectory);
                directories.add(subDirectory);
                continue;
            }
            ZipDocument document = new ZipDocument(otherEntry, zip);
            documents.add(document);
        }
        ZipDirectory result = new ZipDirectory(entry, subdirectories, documents);
        return result;
    }
}

