/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document.impl.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.rat.document.IDocument;
import org.apache.rat.document.IDocumentCollection;
import org.apache.rat.document.UnreadableArchiveException;
import org.apache.rat.document.impl.zip.ZipUtils;

class ZipDocument
implements IDocument {
    private final ZipEntry entry;
    private final ZipFile zipFile;

    public ZipDocument(ZipEntry entry, ZipFile zipFile) {
        this.entry = entry;
        this.zipFile = zipFile;
    }

    public Reader reader() throws IOException {
        InputStream input = this.zipFile.getInputStream(this.entry);
        InputStreamReader result = new InputStreamReader(input);
        return result;
    }

    public String getName() {
        return ZipUtils.getName(this.entry);
    }

    public String getURL() {
        return ZipUtils.getUrl(this.entry);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[ZipDocument '");
        buffer.append(this.getName());
        buffer.append("']");
        return buffer.toString();
    }

    public IDocumentCollection readArchive() throws IOException {
        throw new UnreadableArchiveException();
    }
}

