/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document.impl.guesser;

import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import org.apache.rat.document.IDocument;
import org.apache.rat.document.IDocumentMatcher;
import org.apache.rat.document.impl.guesser.GuessUtils;

public class BinaryGuesser
implements IDocumentMatcher {
    public static final String[] DATA_EXTENSIONS = new String[]{"DAT", "DOC", "NCB", "IDB", "SUO", "XCF", "RAJ", "CERT", "KS", "TS"};
    public static final String[] EXE_EXTENSIONS = new String[]{"EXE", "DLL", "LIB", "SO", "A", "EXP"};
    public static final String[] KEYSTORE_EXTENSIONS = new String[]{"JKS", "KEYSTORE", "PEM", "CRL"};
    public static final String[] IMAGE_EXTENSIONS = new String[]{"PNG", "PDF", "GIF", "GIFF", "TIF", "TIFF", "JPG", "JPEG", "ICO"};
    public static final String[] BYTECODE_EXTENSIONS = new String[]{"CLASS", "PYD", "OBJ", "PYC"};
    public static final String[] NON_BINARY_EXTENSIONS = new String[]{"AART", "AC", "AM", "BAT", "C", "CAT", "CGI", "CLASSPATH", "CMD", "CONFIG", "CPP", "CSS", "CWIKI", "DATA", "DCL", "DTD", "EGRM", "ENT", "FT", "FN", "FV", "GRM", "G", "H", "HTACCESS", "HTML", "IHTML", "IN", "JAVA", "JMX", "JSP", "JS", "JUNIT", "JX", "MANIFEST", "M4", "MF", "MF", "META", "MOD", "N3", "PEN", "PL", "PM", "POD", "POM", "PROJECT", "PROPERTIES", "PY", "RB", "RDF", "RNC", "RNG", "RNX", "ROLES", "RSS", "SH", "SQL", "SVG", "TLD", "TXT", "TYPES", "VM", "VSL", "WSDD", "WSDL", "XARGS", "XCAT", "XCONF", "XEGRM", "XGRM", "XLEX", "XLOG", "XMAP", "XML", "XROLES", "XSAMPLES", "XSD", "XSL", "XSLT", "XSP", "XUL", "XWEB", "XWELCOME"};
    public static final String JAR_MANIFEST = "MANIFEST.MF";
    public static final String JAVA = "JAVA";
    public static final int HIGH_BYTES_RATIO = 100;
    public static final int TOTAL_READ_RATIO = 30;
    public static final int NON_ASCII_THREASHOLD = 256;
    public static final int ASCII_CHAR_THREASHOLD = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isBinary(IDocument document) {
        boolean result = false;
        Reader reader = null;
        try {
            reader = document.reader();
            result = BinaryGuesser.isBinary(reader);
        }
        catch (IOException e) {
            result = false;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public static boolean isBinary(Reader in) {
        boolean result = false;
        char[] taste = new char[100];
        try {
            int bytesRead = in.read(taste);
            if (bytesRead > 0) {
                int highBytes = 0;
                for (int i = 0; i < bytesRead; ++i) {
                    if (taste[i] <= '\u0100' && taste[i] > '\b') continue;
                    ++highBytes;
                }
                if (highBytes * 100 > bytesRead * 30) {
                    result = true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static final boolean isBinaryData(String name) {
        return BinaryGuesser.extensionMatches(name, DATA_EXTENSIONS);
    }

    public static final boolean isNonBinary(String name) {
        if (name == null) {
            return false;
        }
        return BinaryGuesser.extensionMatches(name.toUpperCase(Locale.US), NON_BINARY_EXTENSIONS);
    }

    public static final boolean isExecutable(String name) {
        return name.equals(JAVA) || BinaryGuesser.extensionMatches(name, EXE_EXTENSIONS) || BinaryGuesser.containsExtension(name, EXE_EXTENSIONS);
    }

    public static boolean containsExtension(String name, String[] exts) {
        boolean result = false;
        for (int i = 0; !result && i < exts.length; ++i) {
            result = name.indexOf("." + exts[i] + ".") >= 0;
        }
        return result;
    }

    public static boolean extensionMatches(String name, String[] exts) {
        boolean result = false;
        for (int i = 0; !result && i < exts.length; ++i) {
            result = name.endsWith("." + exts[i]);
        }
        return result;
    }

    public static boolean isBytecode(String name) {
        return BinaryGuesser.extensionMatches(name, BYTECODE_EXTENSIONS);
    }

    public static final boolean isImage(String name) {
        return BinaryGuesser.extensionMatches(name, IMAGE_EXTENSIONS);
    }

    public static final boolean isKeystore(String name) {
        return BinaryGuesser.extensionMatches(name, KEYSTORE_EXTENSIONS);
    }

    public static final boolean isBinary(String name) {
        if (name == null) {
            return false;
        }
        String normalisedName = GuessUtils.normalise(name);
        return JAR_MANIFEST.equals(name) || BinaryGuesser.isImage(normalisedName) || BinaryGuesser.isKeystore(normalisedName) || BinaryGuesser.isBytecode(normalisedName) || BinaryGuesser.isBinaryData(normalisedName) || BinaryGuesser.isExecutable(normalisedName);
    }

    public boolean matches(IDocument document) {
        String name = document.getName();
        boolean result = BinaryGuesser.isBinary(name);
        if (!result) {
            result = BinaryGuesser.isBinary(document);
        }
        return result;
    }
}

