/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document.impl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.apache.rat.document.IDocument;
import org.apache.rat.document.IDocumentCollection;
import org.apache.rat.document.UnreadableArchiveException;
import org.apache.rat.document.impl.AbstractMonolithicDocument;
import org.apache.rat.document.impl.DocumentImplUtils;

public class MonolithicFileDocument
extends AbstractMonolithicDocument {
    private final File file;

    public static IDocument newInstance(final URL url) {
        if ("file".equals(url.getProtocol())) {
            File f = new File(url.getFile());
            return new MonolithicFileDocument(f);
        }
        return new AbstractMonolithicDocument(url.toExternalForm()){

            public Reader reader() throws IOException {
                return new InputStreamReader(url.openStream(), "UTF-8");
            }
        };
    }

    public MonolithicFileDocument(File file) {
        super(DocumentImplUtils.toName(file));
        this.file = file;
    }

    public IDocumentCollection readArchive() throws IOException {
        throw new UnreadableArchiveException("This file is not an archive");
    }

    public Reader reader() throws IOException {
        return new FileReader(this.file);
    }
}

