/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.annotation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public abstract class AbstractLicenceAppender {
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_JAVA = 1;
    private static final int TYPE_XML = 2;
    private static final int TYPE_HTML = 3;
    private static final int TYPE_CSS = 4;
    private static final int TYPE_JAVASCRIPT = 5;
    private static final int TYPE_APT = 6;
    private static final int TYPE_PROPERTIES = 7;
    private boolean isForced;

    public void append(File document) throws IOException {
        String line;
        int type = this.getType(document);
        if (type == 0) {
            return;
        }
        File newDocument = new File(document.getAbsolutePath() + ".new");
        FileWriter writer = new FileWriter(newDocument);
        FileReader fr = new FileReader(document);
        BufferedReader br = new BufferedReader(fr);
        if (type == 4 || type == 5 || type == 6 || type == 7 || type == 3) {
            writer.write(this.getLicenceHeader(document));
            writer.write(10);
        }
        while ((line = br.readLine()) != null) {
            writer.write(line);
            writer.write(10);
            if (type == 1 && line.startsWith("package ")) {
                writer.write(this.getLicenceHeader(document));
                writer.write(10);
            }
            if (type != 2 || !line.startsWith("<?xml ")) continue;
            writer.write(this.getLicenceHeader(document));
            writer.write(10);
        }
        br.close();
        writer.close();
        if (this.isForced) {
            document.delete();
            boolean renamed = newDocument.renameTo(document.getAbsoluteFile());
            if (!renamed) {
                System.err.println("Failed to rename new file, original file remains unchanged.");
            }
        }
    }

    protected int getType(File document) {
        if (document.getPath().endsWith(".java")) {
            return 1;
        }
        if (document.getPath().endsWith(".xml") || document.getPath().endsWith(".xsl")) {
            return 2;
        }
        if (document.getPath().endsWith(".html") || document.getPath().endsWith(".htm")) {
            return 3;
        }
        if (document.getPath().endsWith(".css")) {
            return 4;
        }
        if (document.getPath().endsWith(".js")) {
            return 5;
        }
        if (document.getPath().endsWith(".apt")) {
            return 6;
        }
        if (document.getPath().endsWith(".properties")) {
            return 7;
        }
        return 0;
    }

    public void setForce(boolean b) {
        this.isForced = b;
    }

    public abstract String getLicenceHeader(File var1);

    protected String getFirstLine(int type) {
        switch (type) {
            case 1: {
                return "/*\n";
            }
            case 2: {
                return "<!--\n";
            }
            case 3: {
                return "<!--\n";
            }
            case 4: {
                return "/*\n";
            }
            case 5: {
                return "/*\n";
            }
            case 6: {
                return "~~\n";
            }
            case 7: {
                return "#\n";
            }
        }
        return "";
    }

    protected String getLastLine(int type) {
        switch (type) {
            case 1: {
                return " */\n";
            }
            case 2: {
                return "-->\n";
            }
            case 3: {
                return "-->\n";
            }
            case 4: {
                return " */\n";
            }
            case 5: {
                return " */\n";
            }
            case 6: {
                return "~~\n";
            }
            case 7: {
                return "#\n";
            }
        }
        return "";
    }

    protected String getLine(int type, String content) {
        switch (type) {
            case 1: {
                return " * " + content + "\n";
            }
            case 2: {
                return " " + content + "\n";
            }
            case 3: {
                return " " + content + "\n";
            }
            case 4: {
                return " * " + content + "\n";
            }
            case 5: {
                return " * " + content + "\n";
            }
            case 6: {
                return "~~ " + content + "\n";
            }
            case 7: {
                return "# " + content + "\n";
            }
        }
        return "";
    }
}

