/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.util;

import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.report.claim.IClaimReporter;

public final class HeaderMatcherMultiplexer
implements IHeaderMatcher {
    private final IHeaderMatcher[] matchers;
    private final int numberOfMatchers;

    public HeaderMatcherMultiplexer(IHeaderMatcher[] matchers) {
        this.matchers = matchers;
        this.numberOfMatchers = matchers.length;
    }

    public boolean match(String subject, String line, IClaimReporter reporter) throws RatHeaderAnalysisException {
        boolean result = false;
        for (int i = 0; i < this.numberOfMatchers && !(result = this.matchers[i].match(subject, line, reporter)); ++i) {
        }
        return result;
    }

    public void reset() {
        for (int i = 0; i < this.numberOfMatchers; ++i) {
            this.matchers[i].reset();
        }
    }
}

