/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.license;

import org.apache.rat.analysis.Claims;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.report.RatReportFailedException;
import org.apache.rat.report.claim.IClaimReporter;

public class BaseLicense {
    private final String code;
    private final String name;
    private final String notes;

    public BaseLicense(String code, String name, String notes) {
        this.code = code;
        this.name = name;
        this.notes = notes;
    }

    public final void reportOnLicense(String subject, IClaimReporter reporter) throws RatHeaderAnalysisException {
        String name = this.getName();
        String code = this.getCode();
        String notes = this.getNotes();
        try {
            Claims.reportStandardClaims(subject, notes, code, name, reporter);
        }
        catch (RatReportFailedException e) {
            throw new RatHeaderAnalysisException("Cannot report on license information", (Throwable)((Object)e));
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getNotes() {
        return this.notes;
    }
}

