/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.license;

import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.analysis.license.BaseLicense;
import org.apache.rat.report.claim.IClaimReporter;

public final class ApacheSoftwareLicense20
extends BaseLicense
implements IHeaderMatcher {
    public static final String FIRST_LICENSE_LINE = "Licensed under the Apache License, Version 2.0 (the \"License\")";
    public static final String LICENSE_REFERENCE_LINE = "http://www.apache.org/licenses/LICENSE-2.0";

    public ApacheSoftwareLicense20() {
        super("AL   ", "Apache License Version 2.0", "");
    }

    public boolean match(String subject, String line, IClaimReporter reporter) throws RatHeaderAnalysisException {
        boolean result = this.matches(line);
        if (result) {
            this.reportOnLicense(subject, reporter);
        }
        return result;
    }

    boolean matches(String line) {
        return line.indexOf(FIRST_LICENSE_LINE, 0) >= 0 || line.indexOf(LICENSE_REFERENCE_LINE, 0) >= 0;
    }

    public void reset() {
    }
}

