/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.generation;

import java.util.regex.Pattern;
import org.apache.rat.analysis.Claims;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.report.RatReportFailedException;
import org.apache.rat.report.claim.IClaimReporter;

public class JavaDocLicenseNotRequired
implements IHeaderMatcher {
    private static final String JAVADOC_REGEX_DEFN = ".*Generated by javadoc.*";
    private static final Pattern JAVADOC_REGEX = Pattern.compile(".*Generated by javadoc.*");

    public boolean match(String subject, String line, IClaimReporter reporter) throws RatHeaderAnalysisException {
        boolean result = JAVADOC_REGEX.matcher(line).matches();
        if (result) {
            this.reportOnLicense(subject, reporter);
        }
        return result;
    }

    private void reportOnLicense(String subject, IClaimReporter reporter) throws RatHeaderAnalysisException {
        try {
            Claims.reportGeneratedClaims(subject, "JavaDocs are generated and so license header is optional", reporter);
        }
        catch (RatReportFailedException e) {
            throw new RatHeaderAnalysisException("Cannot write claims", (Throwable)((Object)e));
        }
    }

    public void reset() {
    }
}

