/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.generation;

import java.util.regex.Pattern;
import org.apache.rat.analysis.Claims;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.report.RatReportFailedException;
import org.apache.rat.report.claim.IClaimReporter;

public class GeneratedLicenseNotRequired
implements IHeaderMatcher {
    private static final Pattern[] DEFAULT_PATTERNS = new Pattern[]{Pattern.compile(".*generated by Cayenne.*"), Pattern.compile(".*Generated By:JJTree.*"), Pattern.compile(".*Generated By:JavaCC.*"), Pattern.compile(".*THIS FILE IS AUTOMATICALLY GENERATED.*"), Pattern.compile(".*NOTE: this file is autogenerated by XBeans.*"), Pattern.compile(".*This file was automatically generated by .*"), Pattern.compile(".*# WARNING: DO NOT EDIT OR DELETE THIS WORKSPACE FILE!.*"), Pattern.compile(".*# Microsoft Developer Studio Generated NMAKE File.*"), Pattern.compile(".*# Microsoft Developer Studio Generated Build File.*"), Pattern.compile(".*Generated from configure.ac by autoheader.*"), Pattern.compile(".*generated automatically by aclocal.*"), Pattern.compile(".*build.xml generated by maven from project.xml.*"), Pattern.compile(".*This file was generated by.*"), Pattern.compile(".*This file has been automatically generated..*"), Pattern.compile(".*Automatically generated - do not modify!.*"), Pattern.compile(".*Javadoc style sheet.*"), Pattern.compile(".*SOURCE FILE GENERATATED.*"), Pattern.compile(".*Generated by the Batik.*"), Pattern.compile(".*this file is autogenerated.*"), Pattern.compile(".*This class was autogenerated.*"), Pattern.compile(".*Generated by Maven.*"), Pattern.compile(".*This class was generated by.*")};
    private final Pattern[] linePatterns;
    private final int numberOfPatterns;

    public GeneratedLicenseNotRequired() {
        this(DEFAULT_PATTERNS);
    }

    public GeneratedLicenseNotRequired(Pattern[] linePatterns) {
        this.linePatterns = linePatterns;
        this.numberOfPatterns = linePatterns.length;
    }

    public boolean match(String subject, String line, IClaimReporter reporter) throws RatHeaderAnalysisException {
        boolean result = false;
        for (int i = 0; i < this.numberOfPatterns; ++i) {
            if (!this.linePatterns[i].matcher(line).matches()) continue;
            result = true;
            this.reportOnLicense(subject, reporter);
            break;
        }
        return result;
    }

    private void reportOnLicense(String subject, IClaimReporter reporter) throws RatHeaderAnalysisException {
        try {
            Claims.reportGeneratedClaims(subject, "Generated files do not required license headers", reporter);
        }
        catch (RatReportFailedException e) {
            throw new RatHeaderAnalysisException("Cannot write claims", (Throwable)((Object)e));
        }
    }

    public void reset() {
    }
}

