/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.File;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.rat.FileNameComparator;
import org.apache.rat.document.impl.FileDocument;
import org.apache.rat.document.impl.zip.ZipFileUnarchiver;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.RatReport;
import org.apache.rat.report.RatReportFailedException;

public class DirectoryWalker
implements IReportable {
    private static final ZipFileUnarchiver UNARCHIVER = new ZipFileUnarchiver();
    private static final FileNameComparator COMPARATOR = new FileNameComparator();
    protected final File file;
    protected final String name;
    private final Pattern ignoreNameRegex;

    public DirectoryWalker(File file) {
        this(file, null);
    }

    public DirectoryWalker(File file, Pattern ignoreNameRegex) {
        this(file.getPath(), file, ignoreNameRegex);
    }

    private DirectoryWalker(String name, File file, Pattern ignoreNameRegex) {
        this.name = name;
        this.file = file;
        this.ignoreNameRegex = ignoreNameRegex;
    }

    public boolean isRestricted() {
        return false;
    }

    protected final boolean ignored(String name) {
        boolean result = false;
        if (this.ignoreNameRegex != null) {
            result = this.ignoreNameRegex.matcher(name).matches();
        }
        return result;
    }

    boolean isRestricted(File file) {
        String name = file.getName();
        boolean result = name.startsWith(".");
        return result;
    }

    private void processDirectory(RatReport report, File file) throws RatReportFailedException {
        if (!this.isRestricted(file)) {
            this.process(report, file);
        }
    }

    public void run(RatReport report) throws RatReportFailedException {
        this.process(report, this.file);
    }

    private void process(RatReport report, File file) throws RatReportFailedException {
        File[] files = file.listFiles();
        Arrays.sort(files, COMPARATOR);
        if (files != null) {
            this.processNonDirectories(report, files);
            this.processDirectories(report, files);
        }
    }

    private void processDirectories(RatReport report, File[] files) throws RatReportFailedException {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String name = file.getName();
            if (this.ignored(name) || !file.isDirectory()) continue;
            this.processDirectory(report, file);
        }
    }

    private void processNonDirectories(RatReport report, File[] files) throws RatReportFailedException {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String name = file.getName();
            if (this.ignored(name) || file.isDirectory()) continue;
            this.report(report, file);
        }
    }

    private void report(RatReport report, File file) throws RatReportFailedException {
        FileDocument document = new FileDocument(file, UNARCHIVER);
        report.report(document);
    }
}

