/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.policy;

import java.util.Arrays;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.license.ILicenseFamily;

public class DefaultPolicy
implements IDocumentAnalyser {
    private static final String[] APPROVED_LICENSES = new String[]{"Apache License Version 2.0", "OASIS Open License", "W3C Software Copyright", "W3C Document Copyright", "Modified BSD License", "The MIT License", "COMMON DEVELOPMENT AND DISTRIBUTION LICENSE Version 1.0"};
    private final String[] approvedLicenseNames;

    private static final String[] toNames(ILicenseFamily[] approvedLicenses) {
        String[] results = null;
        if (approvedLicenses != null) {
            int length = approvedLicenses.length;
            results = new String[length];
            for (int i = 0; i < length; ++i) {
                results[i] = approvedLicenses[i].getFamilyName();
            }
        }
        return results;
    }

    public DefaultPolicy() {
        this(APPROVED_LICENSES);
    }

    public DefaultPolicy(ILicenseFamily[] approvedLicenses) {
        this(DefaultPolicy.toNames(approvedLicenses));
    }

    public DefaultPolicy(String[] approvedLicenseNames) {
        if (approvedLicenseNames == null) {
            this.approvedLicenseNames = APPROVED_LICENSES;
        } else {
            int length = approvedLicenseNames.length;
            this.approvedLicenseNames = new String[length];
            System.arraycopy(approvedLicenseNames, 0, this.approvedLicenseNames, 0, length);
        }
        Arrays.sort(this.approvedLicenseNames);
    }

    public void reportLicenseApprovalClaim(Document subject, boolean isAcceptable) {
        MetaData.Datum datum = isAcceptable ? MetaData.RAT_APPROVED_LICENSE_DATIM_TRUE : MetaData.RAT_APPROVED_LICENSE_DATIM_FALSE;
        subject.getMetaData().set(datum);
    }

    public void analyse(Document subject) throws RatDocumentAnalysisException {
        String name;
        if (subject != null && (name = subject.getMetaData().value("http://org/apache/rat/meta-data#LicenseFamilyName")) != null) {
            boolean isApproved = Arrays.binarySearch(this.approvedLicenseNames, name) >= 0;
            this.reportLicenseApprovalClaim(subject, isApproved);
        }
    }
}

