/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.File;
import java.io.IOException;
import org.apache.poi.util.TempFileCreationStrategy;

public final class TempFile {
    private static TempFileCreationStrategy strategy = new DefaultTempFileCreationStrategy();
    public static final String JAVA_IO_TMPDIR = "java.io.tmpdir";

    public static void setTempFileCreationStrategy(TempFileCreationStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("strategy == null");
        }
        TempFile.strategy = strategy;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return strategy.createTempFile(prefix, suffix);
    }

    public static class DefaultTempFileCreationStrategy
    implements TempFileCreationStrategy {
        private File dir;

        public DefaultTempFileCreationStrategy() {
            this(null);
        }

        public DefaultTempFileCreationStrategy(File dir) {
            this.dir = dir;
        }

        @Override
        public File createTempFile(String prefix, String suffix) throws IOException {
            if (this.dir == null) {
                String tmpDir = System.getProperty(TempFile.JAVA_IO_TMPDIR);
                if (tmpDir == null) {
                    throw new IOException("Systems temporary directory not defined - set the -Djava.io.tmpdir jvm property!");
                }
                this.dir = new File(tmpDir, "poifiles");
            }
            if (!this.dir.exists() && !this.dir.mkdirs() || !this.dir.isDirectory()) {
                throw new IOException("Could not create temporary directory '" + this.dir + "'");
            }
            File newFile = File.createTempFile(prefix, suffix, this.dir);
            if (System.getProperty("poi.keep.tmp.files") == null) {
                newFile.deleteOnExit();
            }
            return newFile;
        }
    }
}

