/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsd;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsd.CapturingXMLEntityResolver;
import org.apache.ode.utils.xsd.DefaultXMLEntityResolver;
import org.apache.ode.utils.xsd.XsdException;
import org.apache.ode.utils.xsd.XsdMessages;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xs.XSModel;
import org.w3c.dom.ls.LSInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSUtils {
    private static final Log __log = LogFactory.getLog(XSUtils.class);
    private static final XsdMessages __msgs = MessageBundle.getMessages(XsdMessages.class);

    public static Map<URI, byte[]> captureSchema(String string, XMLEntityResolver xMLEntityResolver) throws XsdException {
        DOMInputImpl dOMInputImpl = new DOMInputImpl();
        dOMInputImpl.setSystemId(string);
        Map<URI, byte[]> map = XSUtils.captureSchema((LSInput)dOMInputImpl, xMLEntityResolver);
        return map;
    }

    public static Map<URI, byte[]> captureSchema(URI uRI, String string, XMLEntityResolver xMLEntityResolver) throws XsdException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("captureSchema(URI,Text,...): systemURI=" + uRI));
        }
        DOMInputImpl dOMInputImpl = new DOMInputImpl();
        dOMInputImpl.setSystemId(uRI.toString());
        dOMInputImpl.setStringData(string);
        Map<URI, byte[]> map = XSUtils.captureSchema((LSInput)dOMInputImpl, xMLEntityResolver);
        try {
            map.put(uRI, string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return map;
    }

    private static Map<URI, byte[]> captureSchema(LSInput lSInput, XMLEntityResolver xMLEntityResolver) throws XsdException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("captureSchema(LSInput,...): input.systemId=" + lSInput.getSystemId()));
        }
        HashMap<URI, byte[]> hashMap = new HashMap<URI, byte[]>();
        if (xMLEntityResolver == null) {
            xMLEntityResolver = new DefaultXMLEntityResolver();
        }
        CapturingXMLEntityResolver capturingXMLEntityResolver = new CapturingXMLEntityResolver(hashMap, xMLEntityResolver);
        XMLSchemaLoader xMLSchemaLoader = new XMLSchemaLoader();
        xMLSchemaLoader.setEntityResolver((XMLEntityResolver)capturingXMLEntityResolver);
        xMLSchemaLoader.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
        LoggingXmlErrorHandler loggingXmlErrorHandler = new LoggingXmlErrorHandler(__log);
        xMLSchemaLoader.setErrorHandler((XMLErrorHandler)loggingXmlErrorHandler);
        XSModel xSModel = xMLSchemaLoader.load(lSInput);
        if (xSModel == null) {
            List<XMLParseException> list = loggingXmlErrorHandler.getErrors();
            if (list.size() != 0) {
                __log.error((Object)("captureSchema: XMLParseException(s) in " + lSInput));
                XsdException xsdException = null;
                for (XMLParseException xMLParseException : list) {
                    xsdException = new XsdException(xsdException, xMLParseException.getMessage(), xMLParseException.getLineNumber(), xMLParseException.getColumnNumber(), xMLParseException.getLiteralSystemId());
                }
                throw xsdException;
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("captureSchema: NULL model (unknown error) for " + lSInput.getSystemId()));
            }
        }
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LoggingXmlErrorHandler
    implements XMLErrorHandler {
        private Log _log;
        private ArrayList<XMLParseException> _errors = new ArrayList();

        public LoggingXmlErrorHandler(Log log) {
            assert (log != null);
            this._log = log;
        }

        public List<XMLParseException> getErrors() {
            return this._errors;
        }

        public void warning(String string, String string2, XMLParseException xMLParseException) throws XNIException {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("XSDErrorHandler.warning: domain=" + string + ", key=" + string2), (Throwable)xMLParseException);
            }
            if (xMLParseException != null) {
                this._errors.add(xMLParseException);
                throw xMLParseException;
            }
        }

        public void error(String string, String string2, XMLParseException xMLParseException) throws XNIException {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("XSDErrorHandler.error: domain=" + string + ", key=" + string2), (Throwable)xMLParseException);
            }
            if (xMLParseException != null) {
                this._errors.add(xMLParseException);
                throw xMLParseException;
            }
            throw new XNIException("Unknown XSD error state; domain=" + string + ", key=" + string2);
        }

        public void fatalError(String string, String string2, XMLParseException xMLParseException) throws XNIException {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("XSDErrorHandler.fatal: domain=" + string + ", key=" + string2), (Throwable)xMLParseException);
            }
            if (xMLParseException != null) {
                this._errors.add(xMLParseException);
                throw xMLParseException;
            }
            throw new XNIException("Unknown XSD error state; domain=" + string + ", key=" + string2);
        }
    }
}

