/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsd;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.StreamUtils;
import org.apache.ode.utils.fs.FileUtils;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapturingXMLEntityResolver
implements XMLEntityResolver {
    private static final Log __log = LogFactory.getLog(CapturingXMLEntityResolver.class);
    private XMLEntityResolver _resolver;
    private Map<URI, byte[]> _capture;

    public CapturingXMLEntityResolver(Map<URI, byte[]> map, XMLEntityResolver xMLEntityResolver) {
        this._resolver = xMLEntityResolver;
        this._capture = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws XNIException, IOException {
        byte[] byArray;
        InputStream inputStream;
        StringBuffer stringBuffer;
        if (__log.isDebugEnabled()) {
            stringBuffer = new StringBuffer("resolveEntity: base=");
            stringBuffer.append(xMLResourceIdentifier.getBaseSystemId());
            stringBuffer.append(", literal=");
            stringBuffer.append(xMLResourceIdentifier.getLiteralSystemId());
            stringBuffer.append(", expanded=");
            stringBuffer.append(xMLResourceIdentifier.getExpandedSystemId());
            stringBuffer.append(", ns=");
            stringBuffer.append(xMLResourceIdentifier.getNamespace());
            stringBuffer.append(", publicId=");
            stringBuffer.append(xMLResourceIdentifier.getPublicId());
            __log.debug((Object)stringBuffer.toString());
        }
        if ((inputStream = (stringBuffer = this._resolver.resolveEntity(xMLResourceIdentifier)).getByteStream()) == null) {
            __log.debug((Object)("resolveEntity: stream not available for: " + stringBuffer));
            throw new IOException("Unable to locate resource for namespace " + xMLResourceIdentifier.getNamespace());
        }
        try {
            byArray = StreamUtils.read(inputStream);
        }
        finally {
            inputStream.close();
        }
        try {
            URI uRI = new URI(FileUtils.encodePath(xMLResourceIdentifier.getLiteralSystemId() == null ? xMLResourceIdentifier.getNamespace() : xMLResourceIdentifier.getLiteralSystemId()));
            __log.debug((Object)("Captured: " + uRI));
            this._capture.put(uRI, byArray);
        }
        catch (URISyntaxException uRISyntaxException) {
            __log.error((Object)("Invalid URI: " + xMLResourceIdentifier.getLiteralSystemId()));
            throw new XNIException((Exception)uRISyntaxException);
        }
        return this._resolver.resolveEntity(xMLResourceIdentifier);
    }
}

