/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.wsdl;

import javax.xml.namespace.QName;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Node;

public class Messages
extends MessageBundle {
    public String msgDuplicateWSDLImport(String string, String string2) {
        return this.format("Attempted to import WSDL for namespace {0} from multiple locations: definitions from {1} will be ignored", string, string2);
    }

    public String msgWsdlImportNotFound(String string, String string2) {
        return this.format("The WSDL for namespace \"{0}\" could not be found in \"{1}\".", string, string2);
    }

    public String msgNoBindingForOperation(String string) {
        return this.format("No <http:operation> or <soap:operation> for operation {0}", string);
    }

    public String msgMultipleBindingsForOperation(String string) {
        return this.format("Operation {0} has multiple binding elements", string);
    }

    public String msgNoBinding(QName qName) {
        return this.format("No <http:binding> or <soap:binding> for binding {0}", qName);
    }

    public String msgMultipleBindings(QName qName) {
        return this.format("Binding {0} has multiple binding elements", qName);
    }

    public String msgNoHTTPBindingForPort(String string) {
        return this.format("No HTTP binding for port: {0}", string);
    }

    public String msgNoSOAPBindingForPort(String string) {
        return this.format("No SOAP binding for port: {0}", string);
    }

    public String msgNoAddressForPort(String string) {
        return this.format("No address for port {0}", string);
    }

    public String msgMultipleAddressesForPort(String string) {
        return this.format("Multiple addresses for port {0}", string);
    }

    public Throwable msgSOAPBodyDoesNotContainAllRequiredParts() {
        String string = this.format("SOAP body does not contain all required parts");
        return new IllegalArgumentException(string);
    }

    public Throwable msgSoapHeaderMustBeAnElement(Node node) {
        String string = this.format("SOAP header must be an element: {0}.", node);
        return new IllegalArgumentException(string);
    }

    public Throwable msgSoapHeaderMissingRequiredElement(QName qName) {
        String string = this.format("SOAP header missing required element: {0}.", qName);
        return new IllegalArgumentException(string);
    }

    public Throwable msgUndefinedFault(QName qName, String string, String string2, QName qName2) {
        String string3 = this.format("Undefined fault: service {0} port {1} operation {2} fault {3}.", qName, string, string2, qName2);
        return new IllegalArgumentException(string3);
    }

    public Throwable msgOdeMessagePartMissingRequiredElement(QName qName, String string, String string2, QName qName2) {
        String string3 = this.format("Message part is missing required element: service {0} port {1} operation {2} element {3}.", qName, string, string2, qName2);
        return new IllegalArgumentException(string3);
    }

    public Throwable msgBindingDefinesNonElementDocListParts() {
        String string = this.format("Binding defines non-element document literal part(s)");
        return new IllegalArgumentException(string);
    }

    public Throwable msgUnexpectedElementInSOAPBody(QName qName, QName qName2) {
        String string = this.format("Unexpected element in SOAP body: message {0} element {1}.", qName, qName2);
        return new IllegalArgumentException(string);
    }

    public Throwable msgSOAPBodyDoesNotContainRequiredPart(String string) {
        String string2 = this.format("SOAP body does not contain required part: {0}.", string);
        return new IllegalArgumentException(string2);
    }

    public Throwable msgSoapBodyDoesNotContainExpectedPartWrapper(QName qName, String string, QName qName2) {
        String string2 = this.format("SOAP body does not contain expected part wrapper: service {0} port {1} wrapper {2}", qName, string, qName2);
        return new IllegalArgumentException(string2);
    }

    public Throwable msgSoapHeaderReferencesUnkownPart(String string) {
        String string2 = this.format("SOAP header references unknown part: {0}.", string);
        return new IllegalArgumentException(string2);
    }

    public Throwable msgOdeMessageExpected() {
        String string = this.format("Message expected!");
        return new IllegalArgumentException(string);
    }

    public Throwable msgOdeMessageMissingRequiredPart(String string) {
        String string2 = this.format("Message is missing required part: {0}", string);
        return new IllegalArgumentException(string2);
    }

    public Throwable msgUnexpectedBindingClass(Class clazz) {
        String string = this.format("Unexpected class: {0}! Must be passed javax.wsdl.extensions.soap.SOAPBinding or javax.wsdl.extensions.http.HTTPBinding", clazz);
        return new IllegalArgumentException(string);
    }

    public String msgPortDefinitionNotFound(QName qName, String string) {
        return this.format("Port definition not found: service {0} port {1}.", qName, string);
    }

    public Throwable msgBindingOperationNotFound(QName qName, String string, String string2) {
        String string3 = this.format("Binding operation not found: service {0} port {1} name {2}.", qName, string, string2);
        return new IllegalArgumentException(string3);
    }

    public Throwable msgBindingInputNotFound(QName qName, String string, String string2) {
        String string3 = this.format("Binding input not found: service {0} port {1} name {2}.", qName, string, string2);
        return new IllegalArgumentException(string3);
    }

    public Throwable msgBindingOutputNotFound(QName qName, String string, String string2) {
        String string3 = this.format("Binding output not found: service {0} port {1} name {2}.", qName, string, string2);
        return new IllegalArgumentException(string3);
    }

    public String msgServiceDefinitionNotFound(QName qName) {
        return this.format("Service definition not found: {0}.", qName);
    }

    public String msgBindingNotFound(String string) {
        return this.format("Binding not found: port {0}.", string);
    }

    public String msgMultipleMimeContent() {
        return this.format("Multiple MIME Contents found!");
    }
}

