/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.StringTokenizer;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.Fragments;

public class ConsoleFormatter {
    private static final int LINE_WIDTH = 76;
    private static final int LEFT_MARGIN = 20;

    private static String spaces(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String formatUsage(String string, Fragments fragments) {
        StringBuffer stringBuffer = new StringBuffer(string + " ");
        String string2 = ConsoleFormatter.spaces(string.length() + 1);
        int n = stringBuffer.length();
        CommandlineFragment[] commandlineFragmentArray = fragments.getFragmentsInUserOrder();
        for (int i = 0; i < commandlineFragmentArray.length; ++i) {
            String string3 = commandlineFragmentArray[i].getUsage();
            if (commandlineFragmentArray[i].isOptional()) {
                string3 = "[" + string3 + "]";
            }
            if (n != string2.length() && n + string3.length() >= 76) {
                stringBuffer.append("\n");
                stringBuffer.append(string2);
                n = string2.length();
            }
            if (n != string2.length()) {
                string3 = ' ' + string3;
            }
            stringBuffer.append(string3);
            n += string3.length();
        }
        return stringBuffer.toString();
    }

    public static String formatHelp(Fragments fragments) {
        CommandlineFragment[] commandlineFragmentArray = fragments.getFragmentsInUserOrder();
        StringBuffer stringBuffer = new StringBuffer();
        String string = ConsoleFormatter.spaces(20);
        for (int i = 0; i < commandlineFragmentArray.length; ++i) {
            String string2 = commandlineFragmentArray[i].getUsage();
            if (string2.length() > 20) {
                stringBuffer.append(string2);
                stringBuffer.append('\n');
                stringBuffer.append(string);
            } else {
                stringBuffer.append(ConsoleFormatter.rightPadToWidth(string2, 20));
            }
            stringBuffer.append(ConsoleFormatter.wrap(commandlineFragmentArray[i].getDescription(), 20));
        }
        return stringBuffer.toString();
    }

    public static String rightPadToWidth(String string, int n) {
        if (string.length() > n) {
            return string;
        }
        return string + ConsoleFormatter.spaces(n - string.length());
    }

    public static String wrap(String string, int n) {
        String string2 = ConsoleFormatter.spaces(n);
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (n2 != n && n2 + string3.length() > 76) {
                stringBuffer.append('\n');
                stringBuffer.append(string2);
                n2 = n;
            }
            if (n2 != n) {
                string3 = ' ' + string3;
            }
            stringBuffer.append(string3);
            n2 += string3.length();
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public static void printSynopsis(String string, String string2, Fragments[] fragmentsArray) {
        System.out.print(string + " - ");
        System.out.println(ConsoleFormatter.wrap(string2, string.length() + 3));
        for (int i = 0; i < fragmentsArray.length; ++i) {
            System.out.println(ConsoleFormatter.formatUsage(string, fragmentsArray[i]));
            System.out.println(ConsoleFormatter.formatHelp(fragmentsArray[i]));
        }
    }
}

