/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemUtils {
    public static String javaVersion() {
        return System.getProperty("java.version");
    }

    public static String javaVendor() {
        return System.getProperty("java.vendor");
    }

    public static String javaHome() {
        return System.getProperty("java.home");
    }

    public static String javaClassVersion() {
        return System.getProperty("java.class.version");
    }

    public static String javaClassPath() {
        return System.getProperty("java.class.path");
    }

    public static String javaTemporaryDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String javaLibraryPath() {
        return System.getProperty("java.library.path");
    }

    public static String operatingSystemArchitecture() {
        return System.getProperty("os.arch");
    }

    public static String operatingSystemName() {
        return System.getProperty("os.name");
    }

    public static String operatingSystemVersion() {
        return System.getProperty("os.version");
    }

    public static String fileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String pathSeparator() {
        return System.getProperty("path.separator");
    }

    public static String lineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String userName() {
        return System.getProperty("user.name");
    }

    public static String userHome() {
        return System.getProperty("user.home");
    }

    public static String userDirectory() {
        return System.getProperty("user.dir");
    }

    public static String replaceSystemProperties(String string) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("\\$\\{[^\\}]+\\}");
        int n = 0;
        while ((matcher = pattern.matcher(string)).find(n)) {
            String string2 = string.substring(matcher.start() + 2, matcher.end() - 1);
            String string3 = System.getProperty(string2);
            if (string3 != null) {
                string = matcher.replaceFirst(Matcher.quoteReplacement(string3));
                continue;
            }
            n = matcher.end();
        }
        return string;
    }
}

