/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

public class SerializableUtils {
    public static Object cloneSerializable(Object object) {
        Object object2 = null;
        try {
            ObjectInputStream objectInputStream;
            block4: {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
                try {
                    object2 = objectInputStream.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            objectInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to clone object: " + object);
        }
        return object2;
    }

    public static byte[] toBytes(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error serializing object: " + object.getClass() + ".", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Object toObject(InputStream inputStream, final ClassLoader classLoader) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                    String string = objectStreamClass.getName();
                    try {
                        return Class.forName(string, false, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return super.resolveClass(objectStreamClass);
                    }
                }
            };
            return objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Object toObject(byte[] byArray, ClassLoader classLoader) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return SerializableUtils.toObject(byteArrayInputStream, classLoader);
    }
}

