/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalProperties {
    private static final Log log = LogFactory.getLog(HierarchicalProperties.class);
    public static final String ODE_PREFFIX = "ode";
    private File[] files;
    private String prefix;
    private String dotted_prefix;
    private MultiKeyMap hierarchicalMap = new MultiKeyMap();
    private transient MultiKeyMap cacheOfImmutableMaps = new MultiKeyMap();

    public HierarchicalProperties(File[] fileArray, String string) throws IOException {
        this.files = fileArray;
        this.prefix = string;
        this.dotted_prefix = "." + string + ".";
        this.loadFiles();
    }

    public HierarchicalProperties(File[] fileArray) throws IOException {
        this(fileArray, ODE_PREFFIX);
    }

    public HierarchicalProperties(File file, String string) throws IOException {
        this(new File[]{file}, string);
    }

    public HierarchicalProperties(File file) throws IOException {
        this(new File[]{file}, ODE_PREFFIX);
    }

    public HierarchicalProperties(List<File> list) throws IOException {
        this(list.toArray(new File[list.size()]), ODE_PREFFIX);
    }

    public void loadFiles() throws IOException {
        this.clear();
        this.hierarchicalMap.put(null, null, (Object)new ChainedMap());
        for (File file : this.files) {
            this.loadFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(File file) throws IOException {
        Object object;
        Object object2;
        String string;
        if (!file.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("File does not exist [" + file + "]"));
            }
            return;
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading property file: " + file));
            }
            properties.load(fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
        HashMap<String[], String> hashMap = new HashMap<String[], String>();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            string = (String)entry.getKey();
            object2 = (String)entry.getValue();
            object2 = SystemUtils.replaceSystemProperties((String)object2);
            properties.put(string, object2);
            if (!string.startsWith("alias.")) continue;
            object = string.substring("alias.".length(), string.length());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Alias found: " + (String)object + " -> " + (String)object2));
            }
            if (hashMap.containsKey(object) && ((String)object2).equals(hashMap.get(object))) {
                throw new RuntimeException("Same alias used twice for 2 different namespaces! file=" + file + ", alias=" + (String)object);
            }
            hashMap.put((String[])object, (String)object2);
            iterator.remove();
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object object3;
            ChainedMap chainedMap;
            string = (String)entry.getKey();
            object2 = (String)entry.getValue();
            object = this.parseProperty(string);
            String string2 = object[0];
            String string3 = object[1];
            String string4 = object[2];
            String string5 = object[3];
            QName qName = null;
            if (string2 != null) {
                qName = new QName(hashMap.get(string2) != null ? (String)hashMap.get(string2) : string2, string3);
            }
            if ((chainedMap = (ChainedMap)this.hierarchicalMap.get(qName, (Object)string4)) == null) {
                object3 = (ChainedMap)this.hierarchicalMap.get((Object)qName, null);
                if (object3 == null) {
                    object3 = new ChainedMap(this.getRootMap());
                    this.hierarchicalMap.put((Object)qName, null, object3);
                }
                chainedMap = new ChainedMap((ChainedMap)object3);
                this.hierarchicalMap.put((Object)qName, (Object)string4, (Object)chainedMap);
            }
            if (string5.endsWith(".file") || string5.endsWith(".path")) {
                object3 = file.toURI().resolve((String)object2).getPath();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("path: " + (String)object2 + " resolved into: " + (String)object3));
                }
                object2 = object3;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("New property: " + string5 + " -> " + (String)object2));
            }
            chainedMap.put(string5, object2);
        }
    }

    public void clear() {
        this.hierarchicalMap.clear();
        this.cacheOfImmutableMaps.clear();
    }

    protected ChainedMap getRootMap() {
        Object object = this.hierarchicalMap.get(null, null);
        if (object == null) {
            object = new ChainedMap();
            this.hierarchicalMap.put(null, null, object);
        }
        return (ChainedMap)object;
    }

    public Map getProperties(String string, String string2) {
        return this.getProperties(new QName(string, string2));
    }

    public Map getProperties(QName qName) {
        return this.getProperties(qName, null);
    }

    public Map getProperties(String string, String string2, String string3) {
        return this.getProperties(new QName(string, string2), string3);
    }

    public Map getProperties(QName qName, String string) {
        if (this.hierarchicalMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Map map = (Map)this.cacheOfImmutableMaps.get((Object)qName, (Object)string);
        if (map != null) {
            return map;
        }
        ChainedMap chainedMap = (ChainedMap)this.hierarchicalMap.get((Object)qName, (Object)string);
        if (chainedMap == null && (chainedMap = (ChainedMap)this.hierarchicalMap.get((Object)qName, null)) == null) {
            return this.getProperties((QName)null, null);
        }
        Map map2 = new HashMap(chainedMap.size() * 15 / 10);
        for (Object e : chainedMap.keySet()) {
            map2.put(e, chainedMap.get(e));
        }
        map2 = Collections.unmodifiableMap(map2);
        this.cacheOfImmutableMaps.put((Object)qName, (Object)string, map2);
        return map2;
    }

    public String getProperty(String string) {
        return (String)this.getRootMap().get(string);
    }

    public String getProperty(String string, String string2, String string3) {
        return this.getProperty(new QName(string, string2), string3);
    }

    public String getProperty(QName qName, String string) {
        return this.getProperty(qName, null, string);
    }

    public String getProperty(String string, String string2, String string3, String string4) {
        return this.getProperty(new QName(string, string2), string3, string4);
    }

    public String getProperty(QName qName, String string, String string2) {
        return (String)this.getProperties(qName, string).get(string2);
    }

    public String getPrefix() {
        return this.prefix;
    }

    private String[] parseProperty(String string) {
        String[] stringArray = new String[4];
        int n = string.indexOf(this.dotted_prefix);
        if (n <= 0) {
            stringArray[3] = string;
        } else {
            stringArray[3] = string.substring(n + this.dotted_prefix.length());
            String string2 = string.substring(0, n);
            String[] stringArray2 = string2.split("\\.");
            if (stringArray2.length != 2 && stringArray2.length != 3) {
                throw new IllegalArgumentException("Invalid property name:" + string + " Expected pattern: [nsalias.service.[port.]" + string2 + ".]property");
            }
            if (stringArray2.length >= 2) {
                stringArray[0] = stringArray2[0];
                stringArray[1] = stringArray2[1];
            }
            if (stringArray2.length > 2) {
                stringArray[2] = stringArray2[2];
            }
        }
        return stringArray;
    }

    private static class ChainedMap {
        private ChainedMap parent;
        private Map child;

        public ChainedMap() {
            this.parent = null;
            this.child = new HashMap();
        }

        public ChainedMap(ChainedMap chainedMap) {
            this.parent = chainedMap;
            this.child = new HashMap();
        }

        public ChainedMap getParent() {
            return this.parent;
        }

        public void setParent(ChainedMap chainedMap) {
            this.parent = chainedMap;
        }

        public Object getLocally(Object object) {
            return this.child.get(object);
        }

        public void clearLocally() {
            this.child.clear();
        }

        public Object get(Object object) {
            Object object2 = this.getLocally(object);
            if (object2 != null) {
                return object2;
            }
            if (this.parent != null) {
                return this.parent.get(object);
            }
            return null;
        }

        public Object put(Object object, Object object2) {
            if (object == null) {
                throw new NullPointerException("Null keys forbidden!");
            }
            return this.child.put(object, object2);
        }

        public void putAll(Map map) {
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return this.child.isEmpty() && (this.parent == null || this.parent.isEmpty());
        }

        public boolean containsKey(Object object) {
            if (object == null) {
                throw new NullPointerException("Null keys forbidden!");
            }
            return this.child.containsKey(object) || this.parent != null && this.parent.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.child.containsValue(object) || this.parent != null && this.parent.containsValue(object);
        }

        public int size() {
            return this.keySet().size();
        }

        public Set keySet() {
            HashSet hashSet = new HashSet(this.child.keySet());
            if (this.parent != null) {
                hashSet.addAll(this.parent.keySet());
            }
            return hashSet;
        }
    }
}

