/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.OptionalCorrelationKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationKeySet
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String VERSION_1 = "1";
    public static final String VERSION_2 = "2";
    private String version = "2";
    private final Set<CorrelationKey> correlationKeys = new TreeSet<CorrelationKey>(new CorrelationKeyComparator());

    public CorrelationKeySet() {
    }

    public CorrelationKeySet(String string) {
        this.restore(string);
    }

    public CorrelationKeySet add(CorrelationKey correlationKey) {
        for (CorrelationKey correlationKey2 : this.correlationKeys) {
            if (correlationKey2.getCorrelationSetName() != correlationKey.getCorrelationSetName()) continue;
            this.correlationKeys.remove(correlationKey);
            break;
        }
        this.correlationKeys.add(correlationKey);
        return this;
    }

    public boolean isOpaque() {
        return this.correlationKeys.size() == 1 && this.correlationKeys.iterator().next().getCorrelationSetName().equals("-1");
    }

    public boolean isRoutableTo(CorrelationKeySet correlationKeySet, boolean bl) {
        boolean bl2 = this.containsAll(correlationKeySet);
        if (bl) {
            bl2 = bl2 || correlationKeySet.isOpaque() && this.isEmpty();
        }
        return bl2;
    }

    public boolean containsAll(CorrelationKeySet correlationKeySet) {
        Iterator<CorrelationKey> iterator = correlationKeySet.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.correlationKeys.isEmpty();
    }

    public boolean contains(CorrelationKey correlationKey) {
        Iterator<CorrelationKey> iterator = this.correlationKeys.iterator();
        if (correlationKey == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!correlationKey.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public Iterator<CorrelationKey> iterator() {
        return this.correlationKeys.iterator();
    }

    public void clear() {
        this.correlationKeys.clear();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CorrelationKeySet)) {
            return false;
        }
        CorrelationKeySet correlationKeySet = (CorrelationKeySet)object;
        if (this.correlationKeys.size() != correlationKeySet.correlationKeys.size()) {
            return false;
        }
        return this.containsAll(correlationKeySet);
    }

    public List<CorrelationKeySet> findSubSets() {
        ArrayList<CorrelationKeySet> arrayList = new ArrayList<CorrelationKeySet>();
        CorrelationKey correlationKey = null;
        boolean bl = false;
        CorrelationKeySet correlationKeySet = new CorrelationKeySet();
        for (CorrelationKey serializable : this.correlationKeys) {
            if (serializable.getCorrelationSetName().equals("-1")) {
                correlationKey = serializable;
            } else {
                bl = true;
            }
            correlationKeySet.add(serializable);
        }
        if (correlationKey != null && bl) {
            correlationKeySet.correlationKeys.remove(correlationKey);
        }
        int n = 0;
        while ((double)n < Math.pow(2.0, correlationKeySet.correlationKeys.size())) {
            CorrelationKeySet correlationKeySet2 = new CorrelationKeySet();
            Iterator<CorrelationKey> iterator = correlationKeySet.iterator();
            for (int i = n; iterator.hasNext() && i > 0; i >>= 1) {
                CorrelationKey correlationKey2 = iterator.next();
                if ((i & 1) <= 0) continue;
                correlationKeySet2.add(correlationKey2);
            }
            if (!correlationKeySet2.isEmpty()) {
                arrayList.add(correlationKeySet2);
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new CorrelationKeySet());
        }
        return arrayList;
    }

    public String toCanonicalString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (CorrelationKey correlationKey : this.correlationKeys) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("[").append(CorrelationKeySet.escapeRightBracket(correlationKey.toCanonicalString())).append("]");
        }
        return "@2" + stringBuffer.toString();
    }

    private static String escapeRightBracket(String string) {
        char[] cArray;
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : cArray = string.toCharArray()) {
            if (c == ']') {
                stringBuffer.append("]]");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.correlationKeys.toString();
    }

    public void restore(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        if (string.startsWith("@")) {
            this.parseCanonicalForm(string);
        } else {
            this.version = VERSION_1;
            this.add(new CorrelationKey(string));
        }
    }

    private void parseCanonicalForm(String string) {
        ParserState parserState = ParserState.INITIAL;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (parserState == ParserState.INITIAL) {
                if (c == '@') {
                    parserState = ParserState.MET_ALPHA;
                    continue;
                }
                stringBuffer.append(c);
                parserState = ParserState.MET_LEFT_BRACKET;
                continue;
            }
            if (parserState == ParserState.MET_ALPHA) {
                if (c == '[') {
                    this.version = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    parserState = ParserState.MET_LEFT_BRACKET;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (parserState == ParserState.MET_LEFT_BRACKET) {
                if (c == ']') {
                    parserState = ParserState.MET_RIGHT_BRACKET;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (parserState == ParserState.MET_RIGHT_BRACKET) {
                if (c == ']') {
                    stringBuffer.append(c);
                    parserState = ParserState.MET_LEFT_BRACKET;
                    continue;
                }
                if (c == ',') {
                    if (stringBuffer.toString().trim().length() != 0) {
                        this.add(new CorrelationKey(stringBuffer.toString()));
                    }
                    stringBuffer.setLength(0);
                    parserState = ParserState.MET_COMMA;
                    continue;
                }
                if (c != '?') continue;
                if (stringBuffer.toString().trim().length() != 0) {
                    this.add(new OptionalCorrelationKey(stringBuffer.toString()));
                }
                stringBuffer.setLength(0);
                parserState = ParserState.MET_COMMA;
                continue;
            }
            if (parserState != ParserState.MET_COMMA || c != '[') continue;
            parserState = ParserState.MET_LEFT_BRACKET;
        }
        if (stringBuffer.toString().trim().length() != 0) {
            if (parserState == ParserState.MET_ALPHA) {
                this.version = stringBuffer.toString();
            } else {
                this.add(new CorrelationKey(stringBuffer.toString()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CorrelationKeyComparator
    implements Serializable,
    Comparator<CorrelationKey> {
        private static final long serialVersionUID = 1L;

        private CorrelationKeyComparator() {
        }

        @Override
        public int compare(CorrelationKey correlationKey, CorrelationKey correlationKey2) {
            if (correlationKey == null || correlationKey2 == null) {
                return 0;
            }
            return correlationKey.getCorrelationSetName().compareTo(correlationKey2.getCorrelationSetName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParserState {
        INITIAL,
        MET_ALPHA,
        MET_LEFT_BRACKET,
        MET_RIGHT_BRACKET,
        MET_COMMA;

    }
}

