/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.naming.NamingException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;
import org.apache.myfaces.config.element.ListEntries;
import org.apache.myfaces.config.element.ListEntry;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.ManagedProperty;
import org.apache.myfaces.config.element.MapEntries;
import org.apache.myfaces.config.element.MapEntry;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.util.ContainerUtils;

public class ManagedBeanBuilder {
    private static Log log = LogFactory.getLog(ManagedBeanBuilder.class);
    private RuntimeConfig _runtimeConfig;
    public static final String REQUEST = "request";
    public static final String APPLICATION = "application";
    public static final String SESSION = "session";
    public static final String NONE = "none";

    public Object buildManagedBean(FacesContext facesContext, ManagedBean beanConfiguration) throws FacesException {
        try {
            LifecycleProvider lifecycleProvider = LifecycleProviderFactory.getLifecycleProviderFactory().getLifecycleProvider(facesContext.getExternalContext());
            Object bean = lifecycleProvider.newInstance(beanConfiguration.getManagedBeanClassName());
            switch (beanConfiguration.getInitMode()) {
                case 1: {
                    try {
                        this.initializeProperties(facesContext, beanConfiguration.getManagedProperties(), beanConfiguration.getManagedBeanScope(), bean);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(e.getMessage() + " for bean '" + beanConfiguration.getManagedBeanName() + "' check the configuration to make sure all properties correspond with get/set methods", e);
                    }
                }
                case 2: {
                    if (!(bean instanceof Map)) {
                        throw new IllegalArgumentException("Class " + bean.getClass().getName() + " of managed bean " + beanConfiguration.getManagedBeanName() + " is not a Map.");
                    }
                    this.initializeMap(facesContext, beanConfiguration.getMapEntries(), (Map)bean);
                    break;
                }
                case 3: {
                    if (!(bean instanceof List)) {
                        throw new IllegalArgumentException("Class " + bean.getClass().getName() + " of managed bean " + beanConfiguration.getManagedBeanName() + " is not a List.");
                    }
                    this.initializeList(facesContext, beanConfiguration.getListEntries(), (List)bean);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown managed bean type " + bean.getClass().getName() + " for managed bean " + beanConfiguration.getManagedBeanName() + '.');
                }
            }
            return bean;
        }
        catch (IllegalAccessException e) {
            throw new FacesException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new FacesException((Throwable)e);
        }
        catch (NamingException e) {
            throw new FacesException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new FacesException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private void initializeProperties(FacesContext facesContext, Iterator managedProperties, String targetScope, Object bean) {
        ELResolver elResolver = facesContext.getApplication().getELResolver();
        ELContext elContext = facesContext.getELContext();
        while (managedProperties.hasNext()) {
            ManagedProperty property = (ManagedProperty)managedProperties.next();
            Object value = null;
            switch (property.getType()) {
                case 4: {
                    if (PropertyUtils.isReadable((Object)bean, (String)property.getPropertyName())) {
                        value = elResolver.getValue(elContext, bean, (Object)property.getPropertyName());
                    }
                    Object object = value = value == null ? new ArrayList() : value;
                    if (value instanceof List) {
                        this.initializeList(facesContext, property.getListEntries(), (List)value);
                        break;
                    }
                    if (value != null && value.getClass().isArray()) {
                        int i;
                        int length = Array.getLength(value);
                        ArrayList<Object> temp = new ArrayList<Object>(length);
                        for (i = 0; i < length; ++i) {
                            temp.add(Array.get(value, i));
                        }
                        this.initializeList(facesContext, property.getListEntries(), temp);
                        value = Array.newInstance(value.getClass().getComponentType(), temp.size());
                        length = temp.size();
                        for (i = 0; i < length; ++i) {
                            Array.set(value, i, temp.get(i));
                        }
                        break;
                    }
                    value = new ArrayList();
                    this.initializeList(facesContext, property.getListEntries(), (List)value);
                    break;
                }
                case 1: {
                    if (PropertyUtils.isReadable((Object)bean, (String)property.getPropertyName())) {
                        value = elResolver.getValue(elContext, bean, (Object)property.getPropertyName());
                    }
                    Object object = value = value == null ? new HashMap() : value;
                    if (!(value instanceof Map)) {
                        value = new HashMap();
                    }
                    this.initializeMap(facesContext, property.getMapEntries(), (Map)value);
                    break;
                }
                case 2: {
                    value = null;
                    break;
                }
                case 3: {
                    if (!this.isInValidScope(facesContext, property, targetScope)) {
                        throw new FacesException("Property " + property.getPropertyName() + " references object in a scope with shorter lifetime than the target scope " + targetScope);
                    }
                    value = property.getRuntimeValue(facesContext);
                }
            }
            Class propertyClass = null;
            propertyClass = property.getPropertyClass() == null ? elResolver.getType(elContext, bean, (Object)property.getPropertyName()) : ClassUtils.simpleJavaTypeToClass(property.getPropertyClass());
            if (null == propertyClass) {
                throw new IllegalArgumentException("unable to find the type of property " + property.getPropertyName());
            }
            Object coercedValue = ManagedBeanBuilder.coerceToType(facesContext, value, propertyClass);
            elResolver.setValue(elContext, bean, (Object)property.getPropertyName(), coercedValue);
        }
    }

    public static Object coerceToType(FacesContext facesContext, Object value, Class desiredClass) {
        if (value == null) {
            return null;
        }
        try {
            ExpressionFactory expFactory = facesContext.getApplication().getExpressionFactory();
            return expFactory.coerceToType(value, desiredClass);
        }
        catch (ELException e) {
            String message = "Cannot coerce " + value.getClass().getName() + " to " + desiredClass.getName();
            log.error((Object)message, (Throwable)e);
            throw new FacesException(message, (Throwable)e);
        }
    }

    private boolean isInValidScope(FacesContext facesContext, ManagedProperty property, String targetScope) {
        if (!property.isValueReference()) {
            return true;
        }
        String[] expressions = this.extractExpressions(property.getValueBinding(facesContext).getExpressionString());
        for (int i = 0; i < expressions.length; ++i) {
            String expression = expressions[i];
            if (expression == null) continue;
            String valueScope = this.getScope(facesContext, expression);
            if (targetScope == null || targetScope.equalsIgnoreCase(NONE)) {
                return valueScope == null || valueScope.equalsIgnoreCase(NONE);
            }
            if (targetScope.equalsIgnoreCase(APPLICATION)) {
                return valueScope == null || !valueScope.equalsIgnoreCase(REQUEST) && !valueScope.equalsIgnoreCase(SESSION);
            }
            if (targetScope.equalsIgnoreCase(SESSION)) {
                return valueScope == null || !valueScope.equalsIgnoreCase(REQUEST);
            }
            if (!targetScope.equalsIgnoreCase(REQUEST)) continue;
            return true;
        }
        return false;
    }

    private String getScope(FacesContext facesContext, String expression) {
        String beanName = this.getFirstSegment(expression);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (beanName.equalsIgnoreCase("requestScope")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase("sessionScope")) {
            return SESSION;
        }
        if (beanName.equalsIgnoreCase("applicationScope")) {
            return APPLICATION;
        }
        if (beanName.equalsIgnoreCase("cookie")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase("facesContext")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase("header")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase("headerValues")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase("initParam")) {
            return APPLICATION;
        }
        if (beanName.equalsIgnoreCase("param")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase("paramValues")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase("view")) {
            return REQUEST;
        }
        if (externalContext.getRequestMap().get(beanName) != null) {
            return REQUEST;
        }
        if (externalContext.getSessionMap().get(beanName) != null) {
            return SESSION;
        }
        if (externalContext.getApplicationMap().get(beanName) != null) {
            return APPLICATION;
        }
        ManagedBean mbc = this.getRuntimeConfig(facesContext).getManagedBean(beanName);
        if (mbc != null) {
            return mbc.getManagedBeanScope();
        }
        return null;
    }

    private String getFirstSegment(String expression) {
        int indexDot = expression.indexOf(46);
        int indexBracket = expression.indexOf(91);
        if (indexBracket < 0) {
            return indexDot < 0 ? expression : expression.substring(0, indexDot);
        }
        if (indexDot < 0) {
            return expression.substring(0, indexBracket);
        }
        return expression.substring(0, Math.min(indexDot, indexBracket));
    }

    private String[] extractExpressions(String expressionString) {
        String[] expressions = expressionString.split("\\#\\{");
        for (int i = 0; i < expressions.length; ++i) {
            String expression = expressions[i];
            if (expression.trim().length() == 0) {
                expressions[i] = null;
                continue;
            }
            int index = expression.indexOf(125);
            expressions[i] = expression.substring(0, index);
        }
        return expressions;
    }

    private void initializeMap(FacesContext facesContext, MapEntries mapEntries, Map map) {
        Application application = facesContext.getApplication();
        Class keyClass = mapEntries.getKeyClass() == null ? String.class : ClassUtils.simpleJavaTypeToClass(mapEntries.getKeyClass());
        Class valueClass = mapEntries.getValueClass() == null ? String.class : ClassUtils.simpleJavaTypeToClass(mapEntries.getValueClass());
        ExpressionFactory expFactory = application.getExpressionFactory();
        ELContext elContext = facesContext.getELContext();
        Iterator iterator = mapEntries.getMapEntries();
        while (iterator.hasNext()) {
            ValueExpression valueExpression;
            MapEntry entry = (MapEntry)iterator.next();
            Object key = entry.getKey();
            if (ContainerUtils.isValueReference((String)key)) {
                valueExpression = expFactory.createValueExpression(elContext, (String)key, Object.class);
                key = valueExpression.getValue(elContext);
            }
            if (entry.isNullValue()) {
                map.put(ManagedBeanBuilder.coerceToType(facesContext, key, keyClass), null);
                continue;
            }
            Object value = entry.getValue();
            if (ContainerUtils.isValueReference((String)value)) {
                valueExpression = expFactory.createValueExpression(elContext, (String)value, Object.class);
                value = valueExpression.getValue(elContext);
            }
            map.put(ManagedBeanBuilder.coerceToType(facesContext, key, keyClass), ManagedBeanBuilder.coerceToType(facesContext, value, valueClass));
        }
    }

    private void initializeList(FacesContext facesContext, ListEntries listEntries, List list) {
        Application application = facesContext.getApplication();
        Class valueClass = listEntries.getValueClass() == null ? String.class : ClassUtils.simpleJavaTypeToClass(listEntries.getValueClass());
        ExpressionFactory expFactory = application.getExpressionFactory();
        ELContext elContext = facesContext.getELContext();
        Iterator iterator = listEntries.getListEntries();
        while (iterator.hasNext()) {
            ListEntry entry = (ListEntry)iterator.next();
            if (entry.isNullValue()) {
                list.add(null);
                continue;
            }
            Object value = entry.getValue();
            if (ContainerUtils.isValueReference((String)value)) {
                ValueExpression valueExpression = expFactory.createValueExpression(elContext, (String)value, Object.class);
                value = valueExpression.getValue(elContext);
            }
            list.add(ManagedBeanBuilder.coerceToType(facesContext, value, valueClass));
        }
    }

    private RuntimeConfig getRuntimeConfig(FacesContext facesContext) {
        if (this._runtimeConfig == null) {
            this._runtimeConfig = RuntimeConfig.getCurrentInstance(facesContext.getExternalContext());
        }
        return this._runtimeConfig;
    }
}

