/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.maven.surefire.booter.BooterDeserializer;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireStarter;
import org.apache.maven.surefire.booter.SystemPropertyManager;

public class ForkedBooter {
    public static void main(String[] args) throws Throwable {
        try {
            File surefirePropertiesFile;
            if (args.length > 1) {
                SystemPropertyManager.setSystemProperties(new File(args[1]));
            }
            FileInputStream stream = (surefirePropertiesFile = new File(args[0])).exists() ? new FileInputStream(surefirePropertiesFile) : null;
            BooterDeserializer booterDeserializer = new BooterDeserializer(stream);
            ProviderConfiguration booterConfiguration = booterDeserializer.deserialize();
            StartupConfiguration providerConfiguration = booterDeserializer.getProviderConfiguration();
            SurefireStarter starter = new SurefireStarter(providerConfiguration, booterConfiguration);
            Object forkedTestSet = booterConfiguration.getTestForFork();
            Properties p = booterConfiguration.getProviderProperties();
            int result = forkedTestSet != null ? starter.runSuitesInProcess(forkedTestSet, surefirePropertiesFile, p) : starter.runSuitesInProcess();
            System.exit(result);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

