/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.surefire.report.AbstractTextReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;

public abstract class AbstractFileReporter
extends AbstractTextReporter {
    private File reportsDirectory;

    protected AbstractFileReporter(File reportsDirectory, String format, Boolean trimStackTrace) {
        super(format, trimStackTrace);
        this.reportsDirectory = reportsDirectory;
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        super.testSetStarting(report);
        File reportFile = new File(this.reportsDirectory, report.getName() + ".txt");
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(reportFile));
            writer.println("-------------------------------------------------------------------------------");
            writer.println("Test set: " + report.getName());
            writer.println("-------------------------------------------------------------------------------");
            this.setWriter(writer);
        }
        catch (IOException e) {
            throw new ReporterException("Unable to create file for report: " + e.getMessage(), e);
        }
    }

    public void testSetCompleted(ReportEntry report) throws ReporterException {
        super.testSetCompleted(report);
        this.writer.flush();
        this.writer.close();
        this.writer = null;
    }
}

