/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.BufferedOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.maven.surefire.report.AbstractReporter;
import org.apache.maven.surefire.report.ReportEntry;

public class ConsoleReporter
extends AbstractReporter {
    private static final int BUFFER_SIZE = 4096;
    private PrintWriter writer = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(System.out, 4096)));
    private long batteryStartTime;

    public void writeMessage(String message) {
        this.writer.println(message);
        this.writer.flush();
    }

    public void runStarting(int testCount) {
        this.writer.println();
        this.writer.println("-------------------------------------------------------");
        this.writer.println(" T E S T S");
        this.writer.println("-------------------------------------------------------");
        this.writer.flush();
    }

    public void runAborted(ReportEntry report) {
        this.writer.println("RUN ABORTED");
        this.writer.println(report.getSource().getClass().getName());
        this.writer.println(report.getName());
        this.writer.println(report.getMessage());
        this.writer.println(report.getThrowable().getMessage());
        this.writer.flush();
    }

    public void batteryAborted(ReportEntry report) {
        this.writer.println("BATTERY ABORTED");
        this.writer.println(report.getSource().getClass().getName());
        this.writer.println(report.getName());
        this.writer.println(report.getMessage());
        this.writer.println(report.getThrowable().getMessage());
        this.writer.flush();
    }

    public void batteryStarting(ReportEntry report) throws Exception {
        this.batteryStartTime = System.currentTimeMillis();
        this.writer.println("[surefire] Running " + report.getName());
    }

    public void batteryCompleted(ReportEntry report) {
        long runTime = System.currentTimeMillis() - this.batteryStartTime;
        this.writer.print("[surefire] Tests run: " + this.completedCount + ", Failures: " + this.failures + ", Errors: " + this.errors + ", Time elapsed: " + this.elapsedTimeAsString(runTime) + " sec");
        if (this.failures > 0 || this.errors > 0) {
            this.writer.print(" <<<<<<<< FAILURE !! ");
        }
        this.writer.println();
        this.writer.flush();
        this.completedCount = 0;
        this.errors = 0;
        this.failures = 0;
    }
}

