/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.battery;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterManager;

public class TestListenerInvocationHandler
implements InvocationHandler {
    private static final String START_TEST = "startTest";
    private static final String ADD_FAILURE = "addFailure";
    private static final String ADD_ERROR = "addError";
    private static final String END_TEST = "endTest";
    private HashSet failedTestsSet = new HashSet();
    private ReporterManager reportManager;

    public TestListenerInvocationHandler(ReporterManager reportManager, Object instanceOfTestResult, ClassLoader loader) {
        if (reportManager == null) {
            throw new NullPointerException("reportManager is null");
        }
        if (instanceOfTestResult == null) {
            throw new NullPointerException("instanceOfTestResult is null");
        }
        if (loader == null) {
            throw new NullPointerException("loader is null");
        }
        this.reportManager = reportManager;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals(START_TEST)) {
            this.handleStartTest(args);
        } else if (methodName.equals(ADD_ERROR)) {
            this.handleAddError(args);
        } else if (methodName.equals(ADD_FAILURE)) {
            this.handleAddFailure(args);
        } else if (methodName.equals(END_TEST)) {
            this.handleEndTest(args);
        }
        return null;
    }

    public void handleStartTest(Object[] args) {
        ReportEntry report = new ReportEntry(args[0], args[0].toString(), args[0].getClass().getName());
        this.reportManager.testStarting(report);
    }

    private void handleAddError(Object[] args) {
        ReportEntry report = new ReportEntry(args[0], args[0].toString(), args[1].toString(), (Throwable)args[1]);
        this.reportManager.testError(report);
        this.failedTestsSet.add(new FailedTest(args[0], Thread.currentThread()));
    }

    private void handleAddFailure(Object[] args) {
        ReportEntry report = new ReportEntry(args[0], args[0].toString(), args[1].toString(), (Throwable)args[1]);
        this.reportManager.testFailed(report);
        this.failedTestsSet.add(new FailedTest(args[0], Thread.currentThread()));
    }

    private void handleEndTest(Object[] args) {
        boolean testHadFailed = this.failedTestsSet.remove(new FailedTest(args[0], Thread.currentThread()));
        if (!testHadFailed) {
            ReportEntry report = new ReportEntry(args[0], args[0].toString(), args[0].getClass().getName());
            this.reportManager.testSucceeded(report);
        }
    }

    private class FailedTest {
        private Object testThatFailed;
        private Thread threadOnWhichTestFailed;

        public FailedTest(Object testThatFailed, Thread threadOnWhichTestFailed) {
            if (testThatFailed == null) {
                throw new NullPointerException("testThatFailed is null");
            }
            if (threadOnWhichTestFailed == null) {
                throw new NullPointerException("threadOnWhichTestFailed is null");
            }
            this.testThatFailed = testThatFailed;
            this.threadOnWhichTestFailed = threadOnWhichTestFailed;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailedTest ft = (FailedTest)o;
            if (ft.testThatFailed != this.testThatFailed) {
                return false;
            }
            return ft.threadOnWhichTestFailed.equals(this.threadOnWhichTestFailed);
        }

        public int hashCode() {
            return this.threadOnWhichTestFailed.hashCode();
        }
    }
}

