/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.InterpolatorFilterReader;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.FileUtils;

public class MavenResourcesExecution {
    private List resources;
    private File outputDirectory;
    private MavenProject mavenProject;
    private String encoding;
    private List fileFilters;
    private List nonFilteredFileExtensions;
    private MavenSession mavenSession;
    private List filterWrappers;
    private File resourcesBaseDirectory;
    private boolean useDefaultFilterWrappers = false;
    private List projectStartExpressions = new ArrayList();
    private String escapeString;
    private boolean overwrite = false;
    private boolean includeEmptyDirs = false;

    public MavenResourcesExecution() {
        this.projectStartExpressions.add("pom");
        this.projectStartExpressions.add("project");
    }

    public MavenResourcesExecution(List resources, File outputDirectory, MavenProject mavenProject, String encoding, List fileFilters, List nonFilteredFileExtensions, MavenSession mavenSession) {
        this();
        this.resources = resources;
        this.outputDirectory = outputDirectory;
        this.mavenProject = mavenProject;
        this.encoding = encoding;
        this.fileFilters = fileFilters;
        this.nonFilteredFileExtensions = nonFilteredFileExtensions;
        this.mavenSession = mavenSession;
        this.useDefaultFilterWrappers = true;
        this.resourcesBaseDirectory = mavenProject.getBasedir();
    }

    public MavenResourcesExecution(List resources, File outputDirectory, String encoding, List filterWrappers, File resourcesBaseDirectory, List nonFilteredFileExtensions) {
        this();
        this.resources = resources;
        this.outputDirectory = outputDirectory;
        this.encoding = encoding;
        this.filterWrappers = filterWrappers;
        this.nonFilteredFileExtensions = nonFilteredFileExtensions;
        this.resourcesBaseDirectory = resourcesBaseDirectory;
        this.useDefaultFilterWrappers = false;
    }

    public List getResources() {
        return this.resources;
    }

    public void setResources(List resources) {
        this.resources = resources;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public List getFileFilters() {
        return this.fileFilters;
    }

    public void setFileFilters(List fileFilters) {
        this.fileFilters = fileFilters;
    }

    public List getNonFilteredFileExtensions() {
        return this.nonFilteredFileExtensions;
    }

    public void setNonFilteredFileExtensions(List nonFilteredFileExtensions) {
        this.nonFilteredFileExtensions = nonFilteredFileExtensions;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public void setMavenSession(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    public List getFilterWrappers() {
        return this.filterWrappers;
    }

    public void setFilterWrappers(List filterWrappers) {
        this.filterWrappers = filterWrappers;
    }

    public void addFilterWrapper(FileUtils.FilterWrapper filterWrapper) {
        if (this.filterWrappers == null) {
            this.filterWrappers = new ArrayList();
        }
        this.filterWrappers.add(filterWrapper);
    }

    public void addFilerWrapper(final ValueSource valueSource) {
        this.addFilterWrapper(new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                RegexBasedInterpolator propertiesInterpolator = new RegexBasedInterpolator();
                propertiesInterpolator.addValueSource(valueSource);
                return new InterpolatorFilterReader(reader, (Interpolator)propertiesInterpolator);
            }
        });
    }

    public void addFilerWrapper(final ValueSource valueSource, final String startRegExp, final String endRegExp, final String startToken, final String endToken) {
        this.addFilterWrapper(new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                RegexBasedInterpolator propertiesInterpolator = new RegexBasedInterpolator(startRegExp, endRegExp);
                propertiesInterpolator.addValueSource(valueSource);
                return new InterpolatorFilterReader(reader, (Interpolator)propertiesInterpolator, startToken, endToken);
            }
        });
    }

    public void addFilerWrapperWithEscaping(final ValueSource valueSource, final String startExp, final String endExp, final String escapeString) {
        this.addFilterWrapper(new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                StringSearchInterpolator propertiesInterpolator = new StringSearchInterpolator(startExp, endExp);
                propertiesInterpolator.addValueSource(valueSource);
                propertiesInterpolator.setEscapeString(escapeString);
                InterpolatorFilterReader interpolatorFilterReader = new InterpolatorFilterReader(reader, (Interpolator)propertiesInterpolator, startExp, endExp);
                interpolatorFilterReader.setInterpolateWithPrefixPattern(false);
                return interpolatorFilterReader;
            }
        });
    }

    public File getResourcesBaseDirectory() {
        return this.resourcesBaseDirectory;
    }

    public void setResourcesBaseDirectory(File resourcesBaseDirectory) {
        this.resourcesBaseDirectory = resourcesBaseDirectory;
    }

    public boolean isUseDefaultFilterWrappers() {
        return this.useDefaultFilterWrappers;
    }

    public void setUseDefaultFilterWrappers(boolean useDefaultFilterWrappers) {
        this.useDefaultFilterWrappers = useDefaultFilterWrappers;
    }

    public List getProjectStartExpressions() {
        return this.projectStartExpressions;
    }

    public void setProjectStartExpressions(List projectStartExpressions) {
        this.projectStartExpressions = projectStartExpressions;
    }

    public String getEscapeString() {
        return this.escapeString;
    }

    public void setEscapeString(String escapeString) {
        this.escapeString = escapeString;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }
}

