/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui.generation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archetype.catalog.Archetype;

public class ArchetypeSelectorUtils {
    private ArchetypeSelectorUtils() {
    }

    private static String extractGroupIdFromFilter(String filter) {
        return StringUtils.contains((String)filter, (char)':') ? StringUtils.substringBefore((String)filter, (String)":") : null;
    }

    private static String extractArtifactIdFromFilter(String filter) {
        return StringUtils.contains((String)filter, (char)':') ? StringUtils.substringAfter((String)filter, (String)":") : filter;
    }

    public static Map<String, List<Archetype>> getFilteredArchetypesByCatalog(Map<String, List<Archetype>> archetypesPerCatalog, String filter) {
        if (archetypesPerCatalog == null || archetypesPerCatalog.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<Archetype>> filtered = new LinkedHashMap<String, List<Archetype>>(archetypesPerCatalog.size());
        for (Map.Entry<String, List<Archetype>> entry : archetypesPerCatalog.entrySet()) {
            ArrayList<Archetype> archetypes = new ArrayList<Archetype>();
            for (Archetype archetype : entry.getValue()) {
                String groupId = ArchetypeSelectorUtils.extractGroupIdFromFilter(filter);
                String artifactId = ArchetypeSelectorUtils.extractArtifactIdFromFilter(filter);
                if (groupId != null && !StringUtils.contains((String)archetype.getGroupId(), (String)groupId) || !StringUtils.contains((String)archetype.getArtifactId(), (String)artifactId)) continue;
                archetypes.add(archetype);
            }
            if (archetypes.isEmpty()) continue;
            filtered.put(entry.getKey(), archetypes);
        }
        return filtered;
    }
}

