/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.mojos;

import java.io.File;
import java.io.IOException;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="jar", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public class JarMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File archetypeDirectory;
    @Parameter(defaultValue="${project.build.finalName}", alias="jarName", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private ArchetypeManager manager;
    @Component
    private ArchetypeArtifactManager archetypeArtifactManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)("Building archetype jar: " + new File(this.outputDirectory, this.finalName)));
            File jarFile = this.manager.archiveArchetype(this.archetypeDirectory, this.outputDirectory, this.finalName);
            this.checkArchetypeFile(jarFile);
            this.project.getArtifact().setFile(jarFile);
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private void checkArchetypeFile(File jarFile) throws MojoExecutionException {
        block4: {
            try {
                if (this.archetypeArtifactManager.isFileSetArchetype(jarFile)) {
                    this.checkFileSetArchetypeFile(jarFile);
                    break block4;
                }
                if (this.archetypeArtifactManager.isOldArchetype(jarFile)) {
                    this.getLog().warn((CharSequence)"Building an Old (1.x) Archetype: consider migrating it to current 2.x Archetype.");
                    break block4;
                }
                throw new MojoExecutionException("The current project does not build an archetype");
            }
            catch (UnknownArchetype ua) {
                throw new MojoExecutionException(ua.getMessage(), (Exception)((Object)ua));
            }
        }
    }

    private void checkFileSetArchetypeFile(File jarFile) throws UnknownArchetype {
        ArchetypeDescriptor archetypeDescriptor = this.archetypeArtifactManager.getFileSetArchetypeDescriptor(jarFile);
        for (RequiredProperty rp : archetypeDescriptor.getRequiredProperties()) {
            if (!rp.getKey().contains(".")) continue;
            this.getLog().warn((CharSequence)("Invalid required property name '" + rp.getKey() + "': dot character makes is unusable in Velocity template"));
        }
    }
}

