/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.mojos;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.exception.ArchetypeNotConfigured;
import org.apache.maven.archetype.generator.ArchetypeGenerator;
import org.apache.maven.archetype.mojos.FileLogger;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.scriptinterpreter.ExecutionLogger;
import org.apache.maven.shared.scriptinterpreter.RunFailureException;
import org.apache.maven.shared.scriptinterpreter.ScriptRunner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

@Mojo(name="integration-test", requiresProject=true)
public class IntegrationTestMojo
extends AbstractMojo {
    @Component
    private ArchetypeGenerator archetypeGenerator;
    @Component
    private Invoker invoker;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="archetype.test.skip")
    private boolean skip = false;
    @Parameter(property="archetype.test.projectsDirectory", defaultValue="${project.build.testOutputDirectory}/projects", required=true)
    private File testProjectsDirectory;
    @Parameter(property="archetype.test.verifyScript", defaultValue="verify")
    private String postBuildHookScript;
    @Parameter(property="archetype.test.noLog", defaultValue="false")
    private boolean noLog;
    @Parameter(property="archetype.test.streamLogs", defaultValue="true")
    private boolean streamLogs;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="archetype.test.localRepositoryPath", defaultValue="${settings.localRepository}", required=true)
    private File localRepositoryPath;
    @Parameter(property="archetype.test.showVersion", defaultValue="false")
    private boolean showVersion;
    @Parameter(property="archetype.test.ignoreEOLStyle", defaultValue="false")
    private boolean ignoreEOLStyle;
    @Parameter(property="archetype.test.debug", defaultValue="false")
    private boolean debug;
    @Parameter
    private Map<String, String> filterProperties;
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    private Settings settings;
    @Parameter(property="archetype.test.settingsFile")
    private File settingsFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (!this.testProjectsDirectory.exists()) {
            this.getLog().warn((CharSequence)"No Archetype IT projects: root 'projects' directory not found.");
            return;
        }
        File archetypeFile = this.project.getArtifact().getFile();
        if (archetypeFile == null) {
            throw new MojoFailureException("Unable to get the archetypes' artifact which should have just been built: you probably launched 'mvn archetype:integration-test' instead of 'mvn integration-test'.");
        }
        try {
            List projectsGoalFiles = FileUtils.getFiles((File)this.testProjectsDirectory, (String)"**/goal.txt", (String)"");
            if (projectsGoalFiles.size() == 0) {
                this.getLog().warn((CharSequence)"No Archetype IT projects: no directory with goal.txt found.");
                return;
            }
            StringWriter errorWriter = new StringWriter();
            for (File goalFile : projectsGoalFiles) {
                try {
                    this.processIntegrationTest(goalFile, archetypeFile);
                }
                catch (IntegrationTestFailure ex) {
                    errorWriter.write("\nArchetype IT '" + goalFile.getParentFile().getName() + "' failed: ");
                    errorWriter.write(ex.getMessage());
                }
            }
            String errors = errorWriter.toString();
            if (!StringUtils.isEmpty((String)errors)) {
                throw new MojoExecutionException(errors);
            }
        }
        catch (IOException ex) {
            throw new MojoFailureException((Object)ex, ex.getMessage(), ex.getMessage());
        }
    }

    private void assertDirectoryEquals(File reference, File actual) throws IntegrationTestFailure, IOException {
        List referenceFiles = FileUtils.getFileAndDirectoryNames((File)reference, (String)"**", null, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        this.getLog().debug((CharSequence)("reference content: " + referenceFiles));
        List actualFiles = FileUtils.getFileAndDirectoryNames((File)actual, (String)"**", null, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        this.getLog().debug((CharSequence)("actual content: " + referenceFiles));
        boolean fileNamesEquals = CollectionUtils.isEqualCollection((Collection)referenceFiles, (Collection)actualFiles);
        if (!fileNamesEquals) {
            this.getLog().debug((CharSequence)"Actual list of files is not the same as reference:");
            int missing = 0;
            for (String ref : referenceFiles) {
                if (actualFiles.contains(ref)) {
                    actualFiles.remove(ref);
                    this.getLog().debug((CharSequence)("Contained " + ref));
                    continue;
                }
                ++missing;
                this.getLog().error((CharSequence)("Not contained " + ref));
            }
            this.getLog().error((CharSequence)("Remains " + actualFiles));
            throw new IntegrationTestFailure("Reference and generated project differs (missing: " + missing + ", unexpected: " + actualFiles.size() + ")");
        }
        boolean contentEquals = true;
        for (String file : referenceFiles) {
            File referenceFile = new File(reference, file);
            File actualFile = new File(actual, file);
            if (referenceFile.isDirectory()) {
                if (!actualFile.isFile()) continue;
                this.getLog().warn((CharSequence)("File " + file + " is a directory in the reference but a file in actual"));
                contentEquals = false;
                continue;
            }
            if (actualFile.isDirectory()) {
                if (!referenceFile.isFile()) continue;
                this.getLog().warn((CharSequence)("File " + file + " is a file in the reference but a directory in actual"));
                contentEquals = false;
                continue;
            }
            if (this.contentEquals(referenceFile, actualFile)) continue;
            this.getLog().warn((CharSequence)("Contents of file " + file + " are not equal"));
            contentEquals = false;
        }
        if (!contentEquals) {
            throw new IntegrationTestFailure("Some content are not equals");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contentEquals(File referenceFile, File actualFile) throws IOException {
        if (!this.ignoreEOLStyle) {
            this.getLog().warn((CharSequence)"Property ignoreEOLStyle was not set - files will be compared considering their EOL style!");
            return FileUtils.contentEquals((File)referenceFile, (File)actualFile);
        }
        this.getLog().debug((CharSequence)"Comparing files with EOL style ignored.");
        referenceFileReader = null;
        actualFileReader = null;
        try {
            referenceFileReader = new BufferedReader(new FileReader(referenceFile));
            actualFileReader = new BufferedReader(new FileReader(actualFile));
            refLine = null;
            actualLine = null;
            while (true) {
                refLine = referenceFileReader.readLine();
                if (StringUtils.equals((String)refLine, (String)(actualLine = actualFileReader.readLine()))) continue;
                var7_7 = false;
                break;
            }
        }
        catch (Throwable var8_9) {
            IOUtil.close(referenceFileReader);
            IOUtil.close(actualFileReader);
            throw var8_9;
        }
        IOUtil.close((Reader)referenceFileReader);
        IOUtil.close((Reader)actualFileReader);
        return var7_7;
        {
            if (refLine != null || actualLine != null) ** continue;
            var7_8 = true;
        }
        IOUtil.close((Reader)referenceFileReader);
        IOUtil.close((Reader)actualFileReader);
        return var7_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File propertiesFile) throws IOException, FileNotFoundException {
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertiesFile);
            properties.load(in);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        return properties;
    }

    private void processIntegrationTest(File goalFile, File archetypeFile) throws IntegrationTestFailure, MojoExecutionException {
        this.getLog().info((CharSequence)("Processing Archetype IT project: " + goalFile.getParentFile().getName()));
        try {
            String goals;
            Properties properties = this.getProperties(goalFile);
            File basedir = new File(goalFile.getParentFile(), "project");
            FileUtils.deleteDirectory((File)basedir);
            FileUtils.mkdir((String)basedir.toString());
            basedir = this.setupParentProjects(goalFile.getParentFile().getParentFile(), basedir);
            ArchetypeGenerationRequest request = this.generate(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), archetypeFile, properties, basedir.toString());
            File reference = new File(goalFile.getParentFile(), "reference");
            if (reference.exists()) {
                this.getLog().info((CharSequence)("Comparing generated project with reference content: " + reference));
                this.assertDirectoryEquals(reference, new File(basedir, request.getArtifactId()));
            }
            if (StringUtils.isNotEmpty((String)(goals = FileUtils.fileRead((File)goalFile)))) {
                this.invokePostArchetypeGenerationGoals(goals.trim(), new File(basedir, request.getArtifactId()), goalFile);
            }
        }
        catch (IOException ioe) {
            throw new IntegrationTestFailure((Throwable)ioe);
        }
    }

    private ArchetypeGenerationRequest generate(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, File archetypeFile, Properties properties, String basedir) throws IntegrationTestFailure {
        ArchetypeGenerationRequest request = new ArchetypeGenerationRequest().setArchetypeGroupId(archetypeGroupId).setArchetypeArtifactId(archetypeArtifactId).setArchetypeVersion(archetypeVersion).setGroupId(properties.getProperty("groupId")).setArtifactId(properties.getProperty("artifactId")).setVersion(properties.getProperty("version")).setPackage(properties.getProperty("package")).setOutputDirectory(basedir).setProperties(properties);
        ArchetypeGenerationResult result = new ArchetypeGenerationResult();
        this.archetypeGenerator.generateArchetype(request, archetypeFile, result);
        if (result.getCause() != null) {
            if (result.getCause() instanceof ArchetypeNotConfigured) {
                ArchetypeNotConfigured anc = (ArchetypeNotConfigured)result.getCause();
                throw new IntegrationTestFailure("Missing required properties in archetype.properties: " + StringUtils.join(anc.getMissingProperties().iterator(), (String)", "), (Throwable)anc);
            }
            throw new IntegrationTestFailure(result.getCause().getMessage(), result.getCause());
        }
        return request;
    }

    private File setupParentProjects(File configFolder, File buildFolder) throws IOException, MojoExecutionException, IntegrationTestFailure {
        File archetypeFile;
        File archetypePomPropertiesFile = new File(configFolder, "archetype.pom.properties");
        if (!archetypePomPropertiesFile.exists()) {
            this.getLog().debug((CharSequence)("No 'archetype.pom.properties' file found in " + configFolder));
            return buildFolder;
        }
        buildFolder = this.setupParentProjects(configFolder.getParentFile(), buildFolder);
        Properties archetypePomProperties = this.loadProperties(archetypePomPropertiesFile);
        String groupId = archetypePomProperties.getProperty("groupId");
        if (StringUtils.isEmpty((String)groupId)) {
            throw new MojoExecutionException("Property groupId not set in " + archetypePomPropertiesFile);
        }
        String artifactId = archetypePomProperties.getProperty("artifactId");
        if (StringUtils.isEmpty((String)artifactId)) {
            throw new MojoExecutionException("Property artifactId not set in " + archetypePomPropertiesFile);
        }
        String version = archetypePomProperties.getProperty("version");
        if (StringUtils.isEmpty((String)version)) {
            throw new MojoExecutionException("Property version not set in " + archetypePomPropertiesFile);
        }
        try {
            archetypeFile = this.getArchetypeFile(groupId, artifactId, version);
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Could not resolve archetype artifact ", (Exception)((Object)e));
        }
        Properties archetypeProperties = this.getProperties(archetypePomPropertiesFile);
        this.getLog().info((CharSequence)("Setting up parent project in " + buildFolder));
        ArchetypeGenerationRequest request = this.generate(groupId, artifactId, version, archetypeFile, archetypeProperties, buildFolder.toString());
        return new File(buildFolder, request.getArtifactId());
    }

    private File getArchetypeFile(String groupId, String artifactId, String version) throws ArtifactResolverException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        if (this.localRepository != null) {
            buildingRequest = buildingRequest.setLocalRepository(this.localRepository);
        }
        if (this.remoteRepositories != null && !this.remoteRepositories.isEmpty()) {
            buildingRequest = buildingRequest.setRemoteRepositories(this.remoteRepositories);
        }
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(groupId);
        coordinate.setArtifactId(artifactId);
        coordinate.setVersion(version);
        return this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, (ArtifactCoordinate)coordinate).getArtifact().getFile();
    }

    private Properties getProperties(File goalFile) throws IOException {
        File propertiesFile = new File(goalFile.getParentFile(), "archetype.properties");
        return this.loadProperties(propertiesFile);
    }

    private void invokePostArchetypeGenerationGoals(String goals, File basedir, File goalFile) throws IntegrationTestFailure, IOException, MojoExecutionException {
        FileLogger logger;
        block10: {
            logger = this.setupLogger(basedir);
            if (!StringUtils.isBlank((String)goals)) {
                this.getLog().info((CharSequence)("Invoking post-archetype-generation goals: " + goals));
                if (!this.localRepositoryPath.exists()) {
                    this.localRepositoryPath.mkdirs();
                }
                InvocationRequest request = new DefaultInvocationRequest().setBaseDirectory(basedir).setGoals(Arrays.asList(StringUtils.split((String)goals, (String)","))).setLocalRepositoryDirectory(this.localRepositoryPath).setInteractive(false).setShowErrors(true);
                request.setDebug(this.debug);
                request.setShowVersion(this.showVersion);
                if (logger != null) {
                    request.setErrorHandler((InvocationOutputHandler)logger);
                    request.setOutputHandler((InvocationOutputHandler)logger);
                }
                File interpolatedSettingsFile = null;
                if (this.settingsFile != null) {
                    File interpolatedSettingsDirectory = new File(this.project.getBuild().getOutputDirectory(), "archetype-it");
                    if (interpolatedSettingsDirectory.exists()) {
                        FileUtils.deleteDirectory((File)interpolatedSettingsDirectory);
                    }
                    interpolatedSettingsDirectory.mkdir();
                    interpolatedSettingsFile = new File(interpolatedSettingsDirectory, "interpolated-" + this.settingsFile.getName());
                    this.buildInterpolatedFile(this.settingsFile, interpolatedSettingsFile);
                    request.setUserSettingsFile(interpolatedSettingsFile);
                }
                try {
                    InvocationResult result = this.invoker.execute(request);
                    this.getLog().info((CharSequence)("Post-archetype-generation invoker exit code: " + result.getExitCode()));
                    if (result.getExitCode() != 0) {
                        throw new IntegrationTestFailure("Execution failure: exit code = " + result.getExitCode(), (Throwable)result.getExecutionException());
                    }
                    break block10;
                }
                catch (MavenInvocationException e) {
                    throw new IntegrationTestFailure("Cannot run additions goals.", e);
                }
            }
            this.getLog().info((CharSequence)"No post-archetype-generation goals to invoke.");
        }
        ScriptRunner scriptRunner = new ScriptRunner(this.getLog());
        scriptRunner.setScriptEncoding(this.encoding);
        LinkedHashMap<String, File> context = new LinkedHashMap<String, File>();
        context.put("projectDir", basedir);
        try {
            scriptRunner.run("post-build script", goalFile.getParentFile(), this.postBuildHookScript, context, (ExecutionLogger)logger, "failure post script", true);
        }
        catch (RunFailureException e) {
            throw new IntegrationTestFailure("post build script failure failure: " + e.getMessage(), e);
        }
    }

    private FileLogger setupLogger(File basedir) throws IOException {
        FileLogger logger = null;
        if (!this.noLog) {
            File outputLog = new File(basedir, "build.log");
            logger = this.streamLogs ? new FileLogger(outputLog, this.getLog()) : new FileLogger(outputLog);
            this.getLog().debug((CharSequence)("build log initialized in: " + outputLog));
        }
        return logger;
    }

    private Map<String, Object> getInterpolationValueSource() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.filterProperties != null) {
            props.putAll(this.filterProperties);
        }
        if (this.filterProperties != null) {
            props.putAll(this.filterProperties);
        }
        props.put("basedir", this.project.getBasedir().getAbsolutePath());
        props.put("baseurl", IntegrationTestMojo.toUrl(this.project.getBasedir().getAbsolutePath()));
        if (this.settings.getLocalRepository() != null) {
            props.put("localRepository", this.settings.getLocalRepository());
            props.put("localRepositoryUrl", IntegrationTestMojo.toUrl(this.settings.getLocalRepository()));
        }
        return new CompositeMap(this.project, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildInterpolatedFile(File originalFile, File interpolatedFile) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Interpolate " + originalFile.getPath() + " to " + interpolatedFile.getPath()));
        try {
            String xml;
            XmlStreamReader reader = null;
            try {
                Map<String, Object> composite = this.getInterpolationValueSource();
                reader = ReaderFactory.newXmlReader((File)originalFile);
                reader = new InterpolationFilterReader((Reader)reader, composite, "@", "@");
                xml = IOUtil.toString((Reader)reader);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
            IOUtil.close((Reader)reader);
            XmlStreamWriter writer = null;
            try {
                interpolatedFile.getParentFile().mkdirs();
                writer = WriterFactory.newXmlWriter((File)interpolatedFile);
                writer.write(xml);
                writer.flush();
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
            IOUtil.close((Writer)writer);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to interpolate file " + originalFile.getPath(), (Exception)e);
        }
    }

    private static String toUrl(String filename) {
        String url = "file://" + new File(filename).toURI().getPath();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private static class CompositeMap
    implements Map<String, Object> {
        private MavenProject mavenProject;
        private Map<String, Object> properties;

        protected CompositeMap(MavenProject mavenProject, Map<String, Object> properties) {
            if (mavenProject == null) {
                throw new IllegalArgumentException("no project specified");
            }
            this.mavenProject = mavenProject;
            this.properties = properties == null ? new Properties() : properties;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof String)) {
                return false;
            }
            String expression = (String)key;
            if (expression.startsWith("project.") || expression.startsWith("pom.")) {
                try {
                    Object evaluated = ReflectionValueExtractor.evaluate((String)expression, (Object)this.mavenProject);
                    if (evaluated != null) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.properties.containsKey(key) || this.mavenProject.getProperties().containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            Object value;
            if (!(key instanceof String)) {
                return null;
            }
            String expression = (String)key;
            if (expression.startsWith("project.") || expression.startsWith("pom.")) {
                try {
                    Object evaluated = ReflectionValueExtractor.evaluate((String)expression, (Object)this.mavenProject);
                    if (evaluated != null) {
                        return evaluated;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return (value = this.properties.get(key)) != null ? value : this.mavenProject.getProperties().get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.mavenProject == null && this.mavenProject.getProperties().isEmpty() && this.properties.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }
    }

    class IntegrationTestFailure
    extends Exception {
        IntegrationTestFailure() {
        }

        IntegrationTestFailure(String message) {
            super(message);
        }

        IntegrationTestFailure(Throwable cause) {
            super(cause);
        }

        IntegrationTestFailure(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

