/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;

public class FileUtil {
    private static String platformDefaultEncoding = new OutputStreamWriter(System.out).getEncoding();

    public static File urlToFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            return null;
        }
        String fileName = url.getFile();
        if (File.separatorChar != '/') {
            fileName = fileName.replace('/', File.separatorChar);
        }
        return new File(fileName);
    }

    public static File urlToFile(String urlName) {
        URL url;
        try {
            url = new URL(urlName);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        return url == null ? null : FileUtil.urlToFile(url);
    }

    public static String urlToFileName(String urlName) {
        File file = FileUtil.urlToFile(urlName);
        return file == null ? null : file.getAbsolutePath();
    }

    public static URL fileToURL(File file) {
        URL url;
        String fileName = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            fileName = fileName.replace(File.separatorChar, '/');
        }
        if (!fileName.startsWith("/")) {
            fileName = "/" + fileName;
        }
        if (!fileName.endsWith("/") && file.isDirectory()) {
            fileName = fileName + "/";
        }
        try {
            url = new URL("file", "", -1, fileName);
        }
        catch (MalformedURLException cannotHappen) {
            url = null;
        }
        return url;
    }

    public static URL fileToURL(String fileName) {
        return FileUtil.fileToURL(new File(fileName));
    }

    public static String fileToURLName(String fileName) {
        URL url = FileUtil.fileToURL(fileName);
        return url == null ? null : url.toExternalForm();
    }

    public static String fileDirName(String fileName) {
        String name;
        char separ = File.separatorChar;
        int slash = fileName.lastIndexOf(separ);
        if (slash < 0 && separ == '\\') {
            separ = '/';
            slash = fileName.lastIndexOf(separ);
        }
        if (slash < 0) {
            name = ".";
        } else if (slash == 0) {
            name = File.separator;
        } else {
            name = fileName.substring(0, slash);
            if (separ != File.separatorChar) {
                name = name.replace(separ, File.separatorChar);
            }
        }
        return name;
    }

    public static String fileBaseName(String fileName) {
        int slash = fileName.lastIndexOf(File.separatorChar);
        if (slash < 0 && File.separatorChar == '\\') {
            slash = fileName.lastIndexOf(47);
        }
        String name = slash < 0 ? fileName : fileName.substring(slash + 1);
        return name;
    }

    public static String fileExtension(String fileName) {
        int slash = fileName.lastIndexOf(File.separatorChar);
        if (slash < 0 && File.separatorChar == '\\') {
            slash = fileName.lastIndexOf(47);
        }
        slash = slash < 0 ? 0 : ++slash;
        int dot = fileName.lastIndexOf(46);
        if (dot <= slash) {
            return "";
        }
        return fileName.substring(dot + 1);
    }

    public static String trimFileExtension(String fileName) {
        int slash = fileName.lastIndexOf(File.separatorChar);
        if (slash < 0 && File.separatorChar == '\\') {
            slash = fileName.lastIndexOf(47);
        }
        slash = slash < 0 ? 0 : ++slash;
        int dot = fileName.lastIndexOf(46);
        if (dot <= slash) {
            return fileName;
        }
        return fileName.substring(0, dot);
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            System.out.println("'" + FileUtil.fileDirName(arg) + "'");
            System.out.println("'" + FileUtil.fileBaseName(arg) + "'");
            System.out.println("'" + FileUtil.trimFileExtension(arg) + "'");
            System.out.println("'" + FileUtil.fileExtension(arg) + "'");
            System.out.println("'" + FileUtil.fileToURLName(arg) + "'");
            System.out.println("---");
        }
    }

    public static boolean removeFile(String fileName) {
        return FileUtil.removeFile(fileName, false);
    }

    public static boolean removeFile(String fileName, boolean force) {
        return FileUtil.removeFile(new File(fileName), force);
    }

    public static boolean removeFile(File file, boolean force) {
        if (file.isDirectory() && force) {
            FileUtil.emptyDirectory(file);
        }
        return file.delete();
    }

    public static void emptyDirectory(String dirName) {
        FileUtil.emptyDirectory(new File(dirName));
    }

    public static void emptyDirectory(File dir) {
        String[] children = dir.list();
        for (int i = 0; i < children.length; ++i) {
            File child = new File(dir, children[i]);
            if (child.isDirectory()) {
                FileUtil.removeFile(child, true);
                continue;
            }
            child.delete();
        }
    }

    public static void copyFile(String srcFileName, String dstFileName) throws IOException {
        int count;
        FileInputStream src = new FileInputStream(srcFileName);
        FileOutputStream dst = new FileOutputStream(dstFileName);
        byte[] bytes = new byte[8192];
        while ((count = src.read(bytes)) != -1) {
            dst.write(bytes, 0, count);
        }
        src.close();
        dst.flush();
        dst.close();
    }

    public static String loadString(String fileName) throws FileNotFoundException, IOException {
        return FileUtil.loadString(new FileInputStream(fileName));
    }

    public static String loadString(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setDefaultUseCaches(false);
        connection.setUseCaches(false);
        connection.setIfModifiedSince(0L);
        return FileUtil.loadString(connection.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(InputStream stream) throws IOException {
        InputStreamReader in = new InputStreamReader(stream);
        char[] chars = new char[8192];
        StringBuffer buffer = new StringBuffer(chars.length);
        try {
            int count;
            while ((count = in.read(chars, 0, chars.length)) != -1) {
                if (count <= 0) continue;
                buffer.append(chars, 0, count);
            }
        }
        finally {
            in.close();
        }
        return buffer.toString();
    }

    public static void saveString(String string, String fileName) throws IOException {
        FileUtil.saveString(string, new FileOutputStream(fileName));
    }

    public static void saveString(String string, OutputStream stream) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(stream);
        out.write(string, 0, string.length());
        out.flush();
        out.close();
    }

    public static byte[] loadBytes(String fileName) throws IOException {
        return FileUtil.loadBytes(new FileInputStream(fileName));
    }

    public static byte[] loadBytes(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setDefaultUseCaches(false);
        connection.setUseCaches(false);
        connection.setIfModifiedSince(0L);
        return FileUtil.loadBytes(connection.getInputStream());
    }

    public static byte[] loadBytes(InputStream source) throws IOException {
        int count;
        BufferedInputStream in = new BufferedInputStream(source);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bytes = new byte[8192];
        while ((count = in.read(bytes)) >= 0) {
            out.write(bytes, 0, count);
        }
        return out.toByteArray();
    }

    public static boolean isGzipped(String fileName) throws IOException {
        FileInputStream in = new FileInputStream(fileName);
        int magic1 = ((InputStream)in).read();
        int magic2 = ((InputStream)in).read();
        ((InputStream)in).close();
        return magic1 == 31 && magic2 == 139;
    }

    public static String loadGzippedString(String fileName) throws IOException {
        return FileUtil.loadGzippedString(new FileInputStream(fileName), null);
    }

    public static String loadGzippedString(URL url) throws IOException {
        return FileUtil.loadGzippedString(url.openStream(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadGzippedString(InputStream source, String encoding) throws IOException {
        if (encoding == null) {
            encoding = FileUtil.defaultEncoding();
        }
        InputStreamReader in = new InputStreamReader((InputStream)new GZIPInputStream(source), encoding);
        char[] chars = new char[8192];
        StringBuffer buffer = new StringBuffer(chars.length);
        try {
            int count;
            while ((count = ((Reader)in).read(chars, 0, chars.length)) != -1) {
                if (count <= 0) continue;
                buffer.append(chars, 0, count);
            }
        }
        finally {
            ((Reader)in).close();
        }
        return buffer.toString();
    }

    public static String defaultEncoding() {
        return platformDefaultEncoding;
    }
}

