/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site.renderer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.module.xhtml.SinkDescriptorReader;
import org.apache.maven.doxia.module.xhtml.XhtmlSink;
import org.apache.maven.doxia.module.xhtml.decoration.model.DecorationModel;
import org.apache.maven.doxia.module.xhtml.decoration.model.DecorationModelReader;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.site.module.SiteModule;
import org.apache.maven.doxia.site.module.manager.SiteModuleManager;
import org.apache.maven.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class DefaultSiteRenderer
implements SiteRenderer {
    private SiteModuleManager siteModuleManager;
    private Doxia doxia;
    private StringWriter writer = new StringWriter();

    public void render(String siteDirectory, String generatedSiteDirectory, String outputDirectory, File resourcesDirectory) throws Exception {
        this.render(siteDirectory, generatedSiteDirectory, outputDirectory, null, "site.xml", resourcesDirectory);
    }

    public void render(String siteDirectory, String generatedSiteDirectory, String outputDirectory, String flavour, File resourcesDirectory) throws Exception {
        this.render(siteDirectory, generatedSiteDirectory, outputDirectory, flavour, "site.xml", resourcesDirectory);
    }

    public void render(String siteDirectory, String generatedSiteDirectory, String outputDirectory, String flavour, String siteDescriptorName, File resourcesDirectory) throws Exception {
        DecorationModelReader decorationModelReader = new DecorationModelReader();
        File siteDescriptor = new File(siteDirectory, siteDescriptorName);
        if (!siteDescriptor.exists()) {
            throw new Exception("The site descriptor is not present!");
        }
        DecorationModel decorationModel = decorationModelReader.createNavigation(siteDescriptor.getPath());
        this.render(siteDirectory, generatedSiteDirectory, outputDirectory, flavour, decorationModel, resourcesDirectory);
    }

    public void render(String siteDirectory, String generatedSiteDirectory, String outputDirectory, String flavour, InputStream siteDescriptor, File resourcesDirectory) throws Exception {
        DecorationModelReader decorationModelReader = new DecorationModelReader();
        if (siteDescriptor == null) {
            throw new Exception("The site descriptor is not present!");
        }
        DecorationModel decorationModel = decorationModelReader.createNavigation(new InputStreamReader(siteDescriptor));
        this.render(siteDirectory, generatedSiteDirectory, outputDirectory, flavour, decorationModel, resourcesDirectory);
    }

    private void render(String siteDirectory, String generatedSiteDirectory, String outputDirectory, String flavour, DecorationModel decorationModel, File resourcesDirectory) throws Exception {
        File moduleBasedir;
        SiteModule module;
        String siteFlavour = flavour;
        if (siteFlavour == null) {
            siteFlavour = decorationModel.getFlavour() == null ? "maven" : decorationModel.getFlavour();
        }
        Iterator i = this.siteModuleManager.getSiteModules().iterator();
        while (i.hasNext()) {
            module = (SiteModule)i.next();
            moduleBasedir = new File(siteDirectory, module.getSourceDirectory());
            if (!moduleBasedir.exists()) continue;
            this.generateModuleDocumentation(siteFlavour, siteDirectory, module, moduleBasedir, decorationModel, outputDirectory);
        }
        i = this.siteModuleManager.getSiteModules().iterator();
        while (i.hasNext()) {
            module = (SiteModule)i.next();
            moduleBasedir = new File(generatedSiteDirectory, module.getSourceDirectory());
            if (!moduleBasedir.exists()) continue;
            this.generateModuleDocumentation(siteFlavour, siteDirectory, module, moduleBasedir, decorationModel, outputDirectory);
        }
        this.copyResources(outputDirectory, siteFlavour);
        if (resourcesDirectory.isDirectory()) {
            FileUtils.copyDirectoryStructure((File)resourcesDirectory, (File)new File(outputDirectory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateModuleDocumentation(String flavour, String siteDirectory, SiteModule module, File moduleBasedir, DecorationModel decorationModel, String outputDirectory) throws Exception {
        List docs = FileUtils.getFileNames((File)moduleBasedir, (String)("**/*." + module.getExtension()), null, (boolean)false);
        Iterator j = docs.iterator();
        while (j.hasNext()) {
            String doc = (String)j.next();
            String fullPathDoc = new File(moduleBasedir, doc).getPath();
            XhtmlSink sink = this.createSink(moduleBasedir, doc, outputDirectory, decorationModel, flavour);
            try {
                FileReader reader = new FileReader(fullPathDoc);
                this.doxia.parse((Reader)reader, module.getParserId(), sink);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Error rendering " + fullPathDoc + ": " + e);
            }
            finally {
                sink.flush();
                sink.close();
            }
        }
    }

    private Map getDirectives(String flavour) throws Exception {
        InputStream is = this.getClass().getResourceAsStream("/" + flavour + ".dst");
        InputStreamReader r = new InputStreamReader(is);
        SinkDescriptorReader sdr = new SinkDescriptorReader();
        return sdr.read(r);
    }

    public XhtmlSink createSink(File moduleBasedir, String doc, String outputDirectory, File siteDescriptor, String flavour) throws Exception {
        DecorationModelReader decorationModelReader = new DecorationModelReader();
        if (!siteDescriptor.exists()) {
            throw new Exception("The site descriptor is not present!");
        }
        DecorationModel decorationModel = decorationModelReader.createNavigation(siteDescriptor.getPath());
        return this.createSink(moduleBasedir, doc, outputDirectory, decorationModel, flavour);
    }

    public XhtmlSink createSink(File moduleBasedir, String doc, String outputDirectory, InputStream siteDescriptor, String flavour) throws Exception {
        DecorationModelReader decorationModelReader = new DecorationModelReader();
        DecorationModel decorationModel = decorationModelReader.createNavigation(new InputStreamReader(siteDescriptor));
        return this.createSink(moduleBasedir, doc, outputDirectory, decorationModel, flavour);
    }

    private XhtmlSink createSink(File moduleBasedir, String doc, String outputDirectory, DecorationModel decorationModel, String flavour) throws Exception {
        String outputName = doc.substring(0, doc.indexOf(".") + 1) + "html";
        File outputFile = new File(outputDirectory, outputName);
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        Map directives = this.getDirectives(flavour);
        RenderingContext renderingContext = new RenderingContext(moduleBasedir, doc, decorationModel);
        return new XhtmlSink(new FileWriter(outputFile), renderingContext, directives);
    }

    public void copyResources(String outputDirectory, String flavour) throws Exception {
        InputStream resourceList = this.getStream(flavour + "/resources.txt");
        if (resourceList != null) {
            String line;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(resourceList));
            while ((line = reader.readLine()) != null) {
                InputStream is = this.getStream(flavour + "/" + line);
                if (is == null) {
                    throw new IOException("The resource " + line + " doesn't exists in " + flavour + " flavour.");
                }
                File outputFile = new File(outputDirectory, line);
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                FileOutputStream w = new FileOutputStream(outputFile);
                IOUtil.copy((InputStream)is, (OutputStream)w);
                IOUtil.close((InputStream)is);
                IOUtil.close((OutputStream)w);
            }
        }
    }

    private InputStream getStream(String name) throws Exception {
        return DefaultSiteRenderer.class.getClassLoader().getResourceAsStream(name);
    }
}

