/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xhtml.decoration.render;

import org.apache.maven.doxia.module.xhtml.decoration.model.Banner;
import org.apache.maven.doxia.module.xhtml.decoration.model.Image;
import org.apache.maven.doxia.module.xhtml.decoration.model.Link;
import org.apache.maven.doxia.module.xhtml.decoration.render.DecorationRenderer;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.codehaus.plexus.util.xml.XMLWriter;

public class BannerRenderer
implements DecorationRenderer {
    private final String id;

    public BannerRenderer(String id) {
        this.id = id;
    }

    public void render(XMLWriter w, RenderingContext renderingContext) {
        Banner banner = this.id.equals("bannerLeft") ? renderingContext.getDecorationModel().getBannerLeft() : renderingContext.getDecorationModel().getBannerRight();
        if (banner != null) {
            Link link = banner.getLink();
            if (link != null) {
                w.startElement("a");
                w.addAttribute("href", link.getHref());
                w.addAttribute("id", this.id);
            } else {
                w.startElement("span");
                w.addAttribute("id", this.id);
            }
            Image image = banner.getImage();
            if (image != null) {
                w.startElement("img");
                w.addAttribute("src", image.getSrc());
                if (image.getAlt() != null) {
                    w.addAttribute("alt", image.getAlt());
                } else {
                    w.addAttribute("alt", "");
                }
                if (image.getTitle() != null) {
                    w.addAttribute("title", image.getTitle());
                }
                w.endElement();
            } else {
                w.writeText(banner.getName());
            }
            w.endElement();
        }
    }
}

