/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink;

import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.markup.XmlMarkup;
import org.apache.maven.doxia.sink.SinkAdapter;

public abstract class AbstractXmlSink
extends SinkAdapter
implements XmlMarkup {
    protected void writeStartTag(HTML.Tag t) {
        this.writeStartTag(t, null);
    }

    protected void writeStartTag(HTML.Tag t, MutableAttributeSet att) {
        this.writeStartTag(t, att, false);
    }

    protected void writeStartTag(HTML.Tag t, MutableAttributeSet att, boolean isSimpleTag) {
        if (t == null) {
            throw new IllegalArgumentException("A tag is required");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf('<'));
        sb.append(t.toString());
        if (att != null) {
            Enumeration<?> names = att.getAttributeNames();
            while (names.hasMoreElements()) {
                Object key = names.nextElement();
                Object value = att.getAttribute(key);
                if (value instanceof AttributeSet) continue;
                sb.append(String.valueOf(' ')).append(key.toString()).append(String.valueOf('=')).append(String.valueOf('\"')).append(value.toString()).append(String.valueOf('\"'));
            }
        }
        if (isSimpleTag) {
            sb.append(String.valueOf(' ')).append(String.valueOf('/'));
        }
        sb.append(String.valueOf('>'));
        if (isSimpleTag) {
            sb.append(EOL);
        }
        this.write(sb.toString());
    }

    protected void writeEndTag(HTML.Tag t) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf('<'));
        sb.append(String.valueOf('/'));
        sb.append(t.toString());
        sb.append(String.valueOf('>'));
        sb.append(EOL);
        this.write(sb.toString());
    }

    protected void writeSimpleTag(HTML.Tag t) {
        this.writeSimpleTag(t, null);
    }

    protected void writeSimpleTag(HTML.Tag t, MutableAttributeSet att) {
        this.writeStartTag(t, att, true);
    }

    protected abstract void write(String var1);
}

