/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.model.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.archetype.model.ArchetypeModel;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class ArchetypeXpp3Writer {
    private XmlSerializer serializer;
    private String NAMESPACE;

    public void write(Writer writer, ArchetypeModel archetype) throws IOException {
        this.serializer = new MXSerializer();
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        this.serializer.setOutput(writer);
        this.serializer.startDocument(archetype.getModelEncoding(), null);
        this.writeArchetypeModel(archetype, "archetype", this.serializer);
        this.serializer.endDocument();
    }

    private void writeArchetypeModel(ArchetypeModel archetypeModel, String tagName, XmlSerializer serializer) throws IOException {
        if (archetypeModel != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (archetypeModel.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(archetypeModel.getId()).endTag(this.NAMESPACE, "id");
            }
            if (archetypeModel.isAllowPartial()) {
                serializer.startTag(this.NAMESPACE, "allowPartial").text(String.valueOf(archetypeModel.isAllowPartial())).endTag(this.NAMESPACE, "allowPartial");
            }
            if (archetypeModel.getSources() != null && archetypeModel.getSources().size() > 0) {
                serializer.startTag(this.NAMESPACE, "sources");
                iter = archetypeModel.getSources().iterator();
                while (iter.hasNext()) {
                    String source = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "source").text(source).endTag(this.NAMESPACE, "source");
                }
                serializer.endTag(this.NAMESPACE, "sources");
            }
            if (archetypeModel.getResources() != null && archetypeModel.getResources().size() > 0) {
                serializer.startTag(this.NAMESPACE, "resources");
                iter = archetypeModel.getResources().iterator();
                while (iter.hasNext()) {
                    String resource = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "resource").text(resource).endTag(this.NAMESPACE, "resource");
                }
                serializer.endTag(this.NAMESPACE, "resources");
            }
            if (archetypeModel.getTestSources() != null && archetypeModel.getTestSources().size() > 0) {
                serializer.startTag(this.NAMESPACE, "testSources");
                iter = archetypeModel.getTestSources().iterator();
                while (iter.hasNext()) {
                    String testSource = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "testSource").text(testSource).endTag(this.NAMESPACE, "testSource");
                }
                serializer.endTag(this.NAMESPACE, "testSources");
            }
            if (archetypeModel.getTestResources() != null && archetypeModel.getTestResources().size() > 0) {
                serializer.startTag(this.NAMESPACE, "testResources");
                iter = archetypeModel.getTestResources().iterator();
                while (iter.hasNext()) {
                    String testResource = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "testResource").text(testResource).endTag(this.NAMESPACE, "testResource");
                }
                serializer.endTag(this.NAMESPACE, "testResources");
            }
            if (archetypeModel.getSiteResources() != null && archetypeModel.getSiteResources().size() > 0) {
                serializer.startTag(this.NAMESPACE, "siteResources");
                iter = archetypeModel.getSiteResources().iterator();
                while (iter.hasNext()) {
                    String siteResource = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "siteResource").text(siteResource).endTag(this.NAMESPACE, "siteResource");
                }
                serializer.endTag(this.NAMESPACE, "siteResources");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

