/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.rio.vcard;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.vcard.Parameter;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardBuilder;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.property.Address;
import net.fortuna.ical4j.vcard.property.Agent;
import net.fortuna.ical4j.vcard.property.Geo;
import net.fortuna.ical4j.vcard.property.Logo;
import net.fortuna.ical4j.vcard.property.N;
import net.fortuna.ical4j.vcard.property.Org;
import net.fortuna.ical4j.vcard.property.Photo;
import net.fortuna.ical4j.vcard.property.Sound;
import net.fortuna.ical4j.vcard.property.Telephone;
import org.apache.marmotta.commons.sesame.rio.vcard.VCardFormat;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.RDFParserBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCardParser
extends RDFParserBase {
    private static Logger log = LoggerFactory.getLogger(VCardParser.class);
    public static final String NS_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String NS_VCARD = "http://www.w3.org/2006/vcard/ns#";
    private static Map<Property.Id, String> propertyMappings = new HashMap<Property.Id, String>();

    public VCardParser() {
        CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
    }

    public VCardParser(ValueFactory valueFactory) {
        super(valueFactory);
        CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
    }

    public RDFFormat getRDFFormat() {
        return VCardFormat.FORMAT;
    }

    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        Preconditions.checkNotNull((Object)baseURI);
        this.setBaseURI(baseURI);
        try {
            for (VCard card : new VCardBuilder(in).buildAll()) {
                this.parseVCard(card);
            }
        }
        catch (ParserException e) {
            throw new RDFParseException((Throwable)e);
        }
    }

    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        Preconditions.checkNotNull((Object)baseURI);
        this.setBaseURI(baseURI);
        try {
            for (VCard card : new VCardBuilder(reader).buildAll()) {
                this.parseVCard(card);
            }
        }
        catch (ParserException e) {
            throw new RDFParseException((Throwable)e);
        }
    }

    private void parseVCard(VCard vCard) throws RDFHandlerException, RDFParseException {
        URI uri = vCard.getProperty(Property.Id.UID) != null ? this.resolveURI(vCard.getProperty(Property.Id.UID).getValue()) : this.resolveURI(UUID.randomUUID().toString());
        URI t_vcard = this.createURI("http://www.w3.org/2006/vcard/ns#VCard");
        URI p_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)uri, p_type, (Value)t_vcard));
        block14: for (Property p : vCard.getProperties()) {
            if (propertyMappings.containsKey(p.getId())) {
                URI prop = this.createURI(propertyMappings.get(p.getId()));
                switch (p.getId()) {
                    case ADR: {
                        this.createAddress(uri, prop, (Address)p);
                        break;
                    }
                    case AGENT: {
                        this.createAgent(uri, prop, (Agent)p);
                        break;
                    }
                    case CATEGORIES: {
                        for (String category : p.getValue().split(",")) {
                            Literal literal = this.createLiteral(category, null, null);
                            this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)literal));
                        }
                        continue block14;
                    }
                    case EMAIL: {
                        URI email = this.createURI("mailto:" + p.getValue());
                        this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)email));
                        break;
                    }
                    case GEO: {
                        this.createLocation(uri, prop, (Geo)p);
                        break;
                    }
                    case LOGO: {
                        this.createLogo(uri, prop, (Logo)p);
                        break;
                    }
                    case N: {
                        this.createName(uri, prop, (N)p);
                        break;
                    }
                    case ORG: {
                        this.createOrganization(uri, prop, (Org)p);
                        break;
                    }
                    case PHOTO: {
                        this.createPhoto(uri, prop, (Photo)p);
                        break;
                    }
                    case SOUND: {
                        this.createSound(uri, prop, (Sound)p);
                        break;
                    }
                    case TEL: {
                        this.createTel(uri, prop, (Telephone)p);
                        break;
                    }
                    case URL: {
                        URI url = this.createURI(p.getValue());
                        this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)url));
                        break;
                    }
                    default: {
                        Literal literal = this.createLiteral(p.getValue(), null, null);
                        this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)literal));
                    }
                }
                continue;
            }
            log.warn("unknown property type {} with value {} not added to RDF representation", (Object)p.getId(), (Object)p.getValue());
        }
    }

    private void createAddress(URI uri, URI prop, Address adr) throws RDFHandlerException, RDFParseException {
        BNode r_adr = this.createBNode();
        URI t_adr = this.createURI("http://www.w3.org/2006/vcard/ns#Address");
        URI p_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_adr, p_type, (Value)t_adr));
        if (adr.getCountry() != null) {
            URI p_country = this.createURI("http://www.w3.org/2006/vcard/ns#country-name");
            Literal v_country = this.createLiteral(adr.getCountry(), null, null);
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_adr, p_country, (Value)v_country));
        }
        if (adr.getExtended() != null && !"".equals(adr.getExtended().trim())) {
            URI p_ext = this.createURI("http://www.w3.org/2006/vcard/ns#extended-address");
            Literal v_ext = this.createLiteral(adr.getExtended(), null, null);
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_adr, p_ext, (Value)v_ext));
        }
        if (adr.getLocality() != null && !"".equals(adr.getLocality().trim())) {
            URI p_locality = this.createURI("http://www.w3.org/2006/vcard/ns#locality");
            Literal v_locality = this.createLiteral(adr.getLocality(), null, null);
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_adr, p_locality, (Value)v_locality));
        }
        if (adr.getPoBox() != null && !"".equals(adr.getPoBox().trim())) {
            URI p_pobox = this.createURI("http://www.w3.org/2006/vcard/ns#post-office-box");
            Literal v_pobox = this.createLiteral(adr.getPoBox(), null, null);
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_adr, p_pobox, (Value)v_pobox));
        }
        if (adr.getPostcode() != null && !"".equals(adr.getPostcode().trim())) {
            URI p_postcode = this.createURI("http://www.w3.org/2006/vcard/ns#postal-code");
            Literal v_postcode = this.createLiteral(adr.getPostcode(), null, null);
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_adr, p_postcode, (Value)v_postcode));
        }
        if (adr.getRegion() != null && !"".equals(adr.getRegion().trim())) {
            URI p_region = this.createURI("http://www.w3.org/2006/vcard/ns#region");
            Literal v_region = this.createLiteral(adr.getRegion(), null, null);
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_adr, p_region, (Value)v_region));
        }
        if (adr.getStreet() != null) {
            URI p_street = this.createURI("http://www.w3.org/2006/vcard/ns#street-address");
            Literal v_street = this.createLiteral(adr.getStreet(), null, null);
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_adr, p_street, (Value)v_street));
        }
        if (adr.getParameter(Parameter.Id.TYPE) != null) {
            int i$ = 0;
            Type type = (Type)adr.getParameter(Parameter.Id.TYPE);
            String[] arr$ = type.getTypes();
            int len$ = arr$.length;
            if (i$ < len$) {
                String value = arr$[i$];
                if ("HOME".equals(value)) {
                    URI p_home = this.createURI("http://www.w3.org/2006/vcard/ns#homeAdr");
                    this.rdfHandler.handleStatement(this.createStatement((Resource)uri, p_home, (Value)r_adr));
                } else if ("WORK".equals(value)) {
                    URI p_work = this.createURI("http://www.w3.org/2006/vcard/ns#workAdr");
                    this.rdfHandler.handleStatement(this.createStatement((Resource)uri, p_work, (Value)r_adr));
                } else {
                    this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)r_adr));
                }
            }
        } else {
            this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)r_adr));
        }
    }

    private void createAgent(URI uri, URI prop, Agent agent) throws RDFHandlerException, RDFParseException {
        if (agent.getUri() != null) {
            URI r_agent = this.createURI(agent.getUri().toString());
            this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)r_agent));
        } else {
            log.warn("ignoring agent relation, since agent cannot be resolved");
        }
    }

    private void createLocation(URI uri, URI prop, Geo geo) throws RDFHandlerException, RDFParseException {
        BNode r_location = this.createBNode();
        URI t_adr = this.createURI("http://www.w3.org/2006/vcard/ns#Location");
        URI p_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_location, p_type, (Value)t_adr));
        URI p_latitute = this.createURI("http://www.w3.org/2006/vcard/ns#latitude");
        URI p_longitude = this.createURI("http://www.w3.org/2006/vcard/ns#longitude");
        URI t_decimal = this.createURI("http://www.w3.org/2001/XMLSchema#double");
        Literal v_latitude = this.createLiteral(geo.getLatitude().toPlainString(), null, t_decimal);
        Literal v_longitude = this.createLiteral(geo.getLongitude().toPlainString(), null, t_decimal);
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_location, p_latitute, (Value)v_latitude));
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_location, p_longitude, (Value)v_longitude));
        this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)r_location));
    }

    private void createLogo(URI uri, URI prop, Logo logo) throws RDFHandlerException, RDFParseException {
        if (logo.getUri() != null) {
            URI r_logo = this.createURI(logo.getUri().toString());
            this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)r_logo));
        } else {
            log.warn("ignoring logo relation, since binary logos are not supported in RDF");
        }
    }

    private void createName(URI uri, URI prop, N name) throws RDFHandlerException, RDFParseException {
        BNode r_name = this.createBNode();
        URI t_name = this.createURI("http://www.w3.org/2006/vcard/ns#Name");
        URI p_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_name, p_type, (Value)t_name));
        if (name.getFamilyName() != null) {
            URI p_family_name = this.createURI("http://www.w3.org/2006/vcard/ns#family-name");
            Literal v_family_name = this.createLiteral(name.getFamilyName(), null, null);
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_name, p_family_name, (Value)v_family_name));
        }
        if (name.getGivenName() != null) {
            URI p_given_name = this.createURI("http://www.w3.org/2006/vcard/ns#given-name");
            Literal v_given_name = this.createLiteral(name.getGivenName(), null, null);
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_name, p_given_name, (Value)v_given_name));
        }
        if (name.getAdditionalNames() != null && name.getAdditionalNames().length > 0) {
            URI p_additional_name = this.createURI("http://www.w3.org/2006/vcard/ns#additional-name");
            for (String additionalName : name.getAdditionalNames()) {
                if ("".equals(additionalName)) continue;
                Literal v_additional_name = this.createLiteral(additionalName, null, null);
                this.rdfHandler.handleStatement(this.createStatement((Resource)r_name, p_additional_name, (Value)v_additional_name));
            }
        }
        if (name.getPrefixes() != null && name.getPrefixes().length > 0) {
            URI p_prefix = this.createURI("http://www.w3.org/2006/vcard/ns#honorific-prefix");
            for (String namePrefix : name.getPrefixes()) {
                if ("".equals(namePrefix)) continue;
                Literal v_prefix = this.createLiteral(namePrefix, null, null);
                this.rdfHandler.handleStatement(this.createStatement((Resource)r_name, p_prefix, (Value)v_prefix));
            }
        }
        if (name.getSuffixes() != null && name.getSuffixes().length > 0) {
            URI p_suffix = this.createURI("http://www.w3.org/2006/vcard/ns#honorific-suffix");
            for (String nameSuffix : name.getSuffixes()) {
                if ("".equals(nameSuffix)) continue;
                Literal v_suffix = this.createLiteral(nameSuffix, null, null);
                this.rdfHandler.handleStatement(this.createStatement((Resource)r_name, p_suffix, (Value)v_suffix));
            }
        }
        this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)r_name));
    }

    private void createOrganization(URI uri, URI prop, Org org) throws RDFHandlerException, RDFParseException {
        for (String orgName : org.getValues()) {
            BNode r_name = this.createBNode();
            URI t_org = this.createURI("http://www.w3.org/2006/vcard/ns#Organization");
            URI p_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_name, p_type, (Value)t_org));
            URI p_name = this.createURI("http://www.w3.org/2006/vcard/ns#organization-name");
            Literal v_name = this.createLiteral(orgName, null, null);
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_name, p_name, (Value)v_name));
            this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)r_name));
        }
    }

    private void createPhoto(URI uri, URI prop, Photo photo) throws RDFHandlerException, RDFParseException {
        if (photo.getUri() != null) {
            URI r_logo = this.createURI(photo.getUri().toString());
            this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)r_logo));
        } else {
            log.warn("ignoring photo relation, since binary photos are not supported in RDF");
        }
    }

    private void createSound(URI uri, URI prop, Sound sound) throws RDFHandlerException, RDFParseException {
        if (sound.getUri() != null) {
            URI r_logo = this.createURI(sound.getUri().toString());
            this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)r_logo));
        } else {
            log.warn("ignoring photo relation, since binary photos are not supported in RDF");
        }
    }

    private void createTel(URI uri, URI prop, Telephone telephone) throws RDFHandlerException, RDFParseException {
        URI r_tel = telephone.getUri() != null ? this.createURI(telephone.getUri().toString()) : this.createURI("tel:" + telephone.getValue());
        if (telephone.getParameter(Parameter.Id.TYPE) != null) {
            int i$ = 0;
            Type type = (Type)telephone.getParameter(Parameter.Id.TYPE);
            String[] arr$ = type.getTypes();
            int len$ = arr$.length;
            if (i$ < len$) {
                String value = arr$[i$];
                if ("HOME".equals(value)) {
                    URI p_home = this.createURI("http://www.w3.org/2006/vcard/ns#homeTel");
                    this.rdfHandler.handleStatement(this.createStatement((Resource)uri, p_home, (Value)r_tel));
                } else if ("WORK".equals(value)) {
                    URI p_work = this.createURI("http://www.w3.org/2006/vcard/ns#workTel");
                    this.rdfHandler.handleStatement(this.createStatement((Resource)uri, p_work, (Value)r_tel));
                } else if ("CELL".equals(value)) {
                    URI p_work = this.createURI("http://www.w3.org/2006/vcard/ns#mobileTel");
                    this.rdfHandler.handleStatement(this.createStatement((Resource)uri, p_work, (Value)r_tel));
                } else {
                    this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)r_tel));
                }
            }
        } else {
            this.rdfHandler.handleStatement(this.createStatement((Resource)uri, prop, (Value)r_tel));
        }
    }

    static {
        propertyMappings.put(Property.Id.ADR, "http://www.w3.org/2006/vcard/ns#adr");
        propertyMappings.put(Property.Id.AGENT, "http://www.w3.org/2006/vcard/ns#agent");
        propertyMappings.put(Property.Id.BDAY, "http://www.w3.org/2006/vcard/ns#bday");
        propertyMappings.put(Property.Id.CATEGORIES, "http://www.w3.org/2006/vcard/ns#category");
        propertyMappings.put(Property.Id.CLASS, "http://www.w3.org/2006/vcard/ns#class");
        propertyMappings.put(Property.Id.EMAIL, "http://www.w3.org/2006/vcard/ns#email");
        propertyMappings.put(Property.Id.EXTENDED, "http://www.w3.org/2006/vcard/ns#extended-address");
        propertyMappings.put(Property.Id.FN, "http://www.w3.org/2006/vcard/ns#fn");
        propertyMappings.put(Property.Id.GEO, "http://www.w3.org/2006/vcard/ns#geo");
        propertyMappings.put(Property.Id.KEY, "http://www.w3.org/2006/vcard/ns#key");
        propertyMappings.put(Property.Id.LABEL, "http://www.w3.org/2006/vcard/ns#label");
        propertyMappings.put(Property.Id.LOGO, "http://www.w3.org/2006/vcard/ns#logo");
        propertyMappings.put(Property.Id.N, "http://www.w3.org/2006/vcard/ns#n");
        propertyMappings.put(Property.Id.NICKNAME, "http://www.w3.org/2006/vcard/ns#nickname");
        propertyMappings.put(Property.Id.NOTE, "http://www.w3.org/2006/vcard/ns#note");
        propertyMappings.put(Property.Id.ORG, "http://www.w3.org/2006/vcard/ns#org");
        propertyMappings.put(Property.Id.PHOTO, "http://www.w3.org/2006/vcard/ns#photo");
        propertyMappings.put(Property.Id.PRODID, "http://www.w3.org/2006/vcard/ns#prodid");
        propertyMappings.put(Property.Id.REV, "http://www.w3.org/2006/vcard/ns#rev");
        propertyMappings.put(Property.Id.ROLE, "http://www.w3.org/2006/vcard/ns#role");
        propertyMappings.put(Property.Id.SORT_STRING, "http://www.w3.org/2006/vcard/ns#sort-string");
        propertyMappings.put(Property.Id.SOUND, "http://www.w3.org/2006/vcard/ns#sound");
        propertyMappings.put(Property.Id.TEL, "http://www.w3.org/2006/vcard/ns#tel");
        propertyMappings.put(Property.Id.TITLE, "http://www.w3.org/2006/vcard/ns#title");
        propertyMappings.put(Property.Id.TZ, "http://www.w3.org/2006/vcard/ns#tz");
        propertyMappings.put(Property.Id.UID, "http://www.w3.org/2006/vcard/ns#uid");
        propertyMappings.put(Property.Id.URL, "http://www.w3.org/2006/vcard/ns#url");
    }
}

