/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.rio.jsonld;

import com.google.common.base.Preconditions;
import de.dfki.km.json.jsonld.JSONLDProcessor;
import de.dfki.km.json.jsonld.JSONLDTripleCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.RDFParserBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLdParser
extends RDFParserBase
implements JSONLDTripleCallback {
    private static Logger log = LoggerFactory.getLogger(JsonLdParser.class);
    JSONLDProcessor processor = new JSONLDProcessor();

    public JsonLdParser() {
    }

    public JsonLdParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (baseURI != null) {
            this.setBaseURI(baseURI);
        }
        ObjectMapper mapper = new ObjectMapper();
        Map object = (Map)mapper.readValue(in, (TypeReference)new TypeReference<Map<String, Object>>(){});
        try {
            this.processor.triples(object, this);
        }
        catch (IllegalArgumentException ex) {
            if (ex.getCause() instanceof RDFParseException) {
                throw (RDFParseException)ex.getCause();
            }
            throw new IllegalArgumentException(ex);
        }
    }

    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (baseURI != null) {
            this.setBaseURI(baseURI);
        }
        ObjectMapper mapper = new ObjectMapper();
        Map object = (Map)mapper.readValue(reader, (TypeReference)new TypeReference<Map<String, Object>>(){});
        try {
            this.processor.triples(object, this);
        }
        catch (IllegalArgumentException ex) {
            if (ex.getCause() instanceof RDFParseException) {
                throw (RDFParseException)ex.getCause();
            }
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public void triple(String s, String p, String o) {
        try {
            this.rdfHandler.handleStatement(this.createStatement((Resource)this.resolveURI(s), this.resolveURI(p), (Value)this.resolveURI(o)));
        }
        catch (OpenRDFException e) {
            log.error("RDF Parse Error while creating statement", (Throwable)e);
            throw new IllegalArgumentException("RDF Parse Error while creating statement", e);
        }
    }

    @Override
    public void triple(String s, String p, String value, String datatype, String language) {
        Preconditions.checkNotNull((Object)s);
        Preconditions.checkNotNull((Object)p);
        Preconditions.checkNotNull((Object)value);
        try {
            URI subject = this.createURI(s);
            URI predicate = this.createURI(p);
            Literal object = language != null ? this.createLiteral(value, language, null) : (datatype != null ? this.createLiteral(value, null, this.createURI(datatype)) : this.createLiteral(value, null, null));
            this.rdfHandler.handleStatement(this.createStatement((Resource)subject, predicate, (Value)object));
        }
        catch (OpenRDFException e) {
            log.error("RDF Parse Error while creating statement", (Throwable)e);
            throw new IllegalArgumentException("RDF Parse Error while creating statement", e);
        }
    }
}

