/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.km.json.jsonld.impl;

import de.dfki.km.json.jsonld.JSONLDSerializer;
import java.util.Iterator;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SesameJSONLDSerializer
extends JSONLDSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(SesameJSONLDSerializer.class);

    public void importGraph(Graph model, Resource ... contexts) {
        Iterator statements = model.match(null, null, null, contexts);
        while (statements.hasNext()) {
            this.handleStatement((Statement)statements.next());
        }
    }

    public void handleStatement(Statement nextStatement) {
        Resource subject = nextStatement.getSubject();
        URI predicate = nextStatement.getPredicate();
        Value object = nextStatement.getObject();
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            String value = literal.getLabel();
            URI datatypeURI = literal.getDatatype();
            String language = literal.getLanguage();
            String datatype = datatypeURI == null ? null : datatypeURI.stringValue();
            this.triple(subject.stringValue(), predicate.stringValue(), value, datatype, language);
        } else {
            this.triple(subject.stringValue(), predicate.stringValue(), object.stringValue());
        }
    }
}

