/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.km.json.jsonld;

import de.dfki.km.json.jsonld.JSONLDTripleCallback;
import de.dfki.km.json.jsonld.JSONLDUtils;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONLDProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JSONLDProcessor.class);
    private JSONLDUtils.NameGenerator ngtmp;
    private Set<String> ignoredKeywords = new HashSet<String>();
    private Map<String, Object> edges;
    private Map<String, Object> subjects;
    private Map<String, Object> renamed;
    private Map<String, Object> serializations;
    private JSONLDUtils.NameGenerator ngc14n;

    public void ignoreKeyword(String keyword) {
        this.ignoredKeywords.add(keyword);
    }

    public Object expand(Object input) {
        return this.expand(new HashMap<String, Object>(), null, input);
    }

    private Object expand(Map<String, Object> ctx, Object property, Object value) {
        HashMap rval = null;
        if (value == null) {
            return null;
        }
        if (property == null && value instanceof String) {
            rval = JSONLDUtils.expandTerm(ctx, (String)value);
        } else if (value instanceof List) {
            rval = new ArrayList();
            for (Object i : (List)value) {
                ((List)((Object)rval)).add(this.expand(ctx, property, i));
            }
        } else if (value instanceof Map) {
            rval = new HashMap();
            if (((Map)value).containsKey("@context")) {
                try {
                    ctx = JSONLDUtils.mergeContexts(ctx, (Map)((Map)value).get("@context"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            rval = new HashMap();
            for (String key : ((Map)value).keySet()) {
                if ("@embed".equals(key) || "@explicit".equals(key) || "@default".equals(key) || "@omitDefault".equals(key) || this.ignoredKeywords.contains(key)) {
                    JSONLDUtils.setProperty(rval, key, JSONLDUtils.clone(((Map)value).get(key)));
                    continue;
                }
                if ("@context".equals(key)) continue;
                JSONLDUtils.setProperty(rval, JSONLDUtils.expandTerm(ctx, key), this.expand(ctx, key, ((Map)value).get(key)));
            }
        } else {
            String coerce = JSONLDUtils.getCoercionType(ctx, (String)property);
            Map<String, String> keywords = JSONLDUtils.getKeywords(ctx);
            if (coerce == null) {
                if (value instanceof Boolean) {
                    coerce = "http://www.w3.org/2001/XMLSchema#boolean";
                } else if (value instanceof Integer) {
                    coerce = "http://www.w3.org/2001/XMLSchema#integer";
                } else if (value instanceof Double) {
                    coerce = "http://www.w3.org/2001/XMLSchema#double";
                }
            }
            if (property.equals("@id") || property.equals(keywords.get("@id")) || property.equals("@type") || property.equals(keywords.get("@type"))) {
                rval = JSONLDUtils.expandTerm(ctx, (String)value);
            } else if (coerce != null) {
                rval = new HashMap();
                if (coerce.equals("@id")) {
                    ((Map)rval).put("@id", JSONLDUtils.expandTerm(ctx, (String)value));
                } else {
                    ((Map)rval).put("@type", coerce);
                    if (coerce.equals("http://www.w3.org/2001/XMLSchema#double")) {
                        DecimalFormat decimalFormat = new DecimalFormat("0.000000E0", new DecimalFormatSymbols(Locale.US));
                        Double v = null;
                        v = value instanceof String ? Double.valueOf(Double.parseDouble((String)value)) : (value instanceof Integer ? new Double(1.0 * (double)((Integer)value).intValue()) : (Double)value);
                        String dec = decimalFormat.format(v);
                        Pattern p = Pattern.compile("(-?[0-9\\.]+)E((?:-*))([0-9]+)");
                        Matcher matcher = p.matcher(dec);
                        matcher.find();
                        String sign = matcher.group(2);
                        if ("".equals(sign)) {
                            sign = "+";
                        }
                        value = matcher.group(1) + "e" + sign + (matcher.group(3).length() > 1 ? matcher.group(3) : "0" + matcher.group(3));
                    } else {
                        value = value.toString();
                    }
                    ((Map)rval).put("@value", value);
                }
            } else {
                rval = value.toString();
            }
        }
        return rval;
    }

    public Object compact(Object context, Object input) {
        HashMap out;
        HashMap<String, Object> ctx;
        HashMap rval = null;
        if (context == null) {
            ctx = new HashMap();
        } else if (context instanceof Map) {
            ctx = (Map)JSONLDUtils.clone(context);
        } else if (context instanceof List) {
            ctx = JSONLDUtils.mergeContexts(new HashMap(), context);
        } else {
            throw new RuntimeException("non-map or list contexts not yes supported");
        }
        input = this.expand(input);
        HashMap<String, Object> ctxOut = new HashMap<String, Object>();
        rval = out = this.compact(ctx, null, input, ctxOut);
        if (ctxOut.size() > 0) {
            rval = new HashMap();
            ((Map)rval).put("@context", ctxOut);
            if (out instanceof List) {
                ((Map)rval).put(JSONLDUtils.getKeywords(ctxOut).get("@id"), out);
            } else {
                for (String key : ((Map)out).keySet()) {
                    ((Map)rval).put(key, ((Map)out).get(key));
                }
            }
        }
        return rval;
    }

    public Object compact(Map<String, Object> ctx, Object property, Object value, Map<String, Object> usedCtx) {
        Object rval = null;
        Map<String, String> keywords = JSONLDUtils.getKeywords(ctx);
        if (value == null) {
            rval = null;
            JSONLDUtils.getCoercionType(ctx, (String)property, usedCtx);
        } else if (value instanceof List) {
            rval = new ArrayList();
            for (Object o : (List)value) {
                ((List)rval).add(this.compact(ctx, property, o, usedCtx));
            }
        } else if (value instanceof Map && ((Map)value).containsKey("@id") && ((Map)value).get("@id") instanceof List) {
            rval = new HashMap();
            ((Map)rval).put(keywords.get("@id"), this.compact(ctx, property, ((Map)value).get("@id"), usedCtx));
        } else if (JSONLDUtils.isSubject(value)) {
            rval = new HashMap();
            for (String key : ((Map)value).keySet()) {
                String p;
                if ("@context".equals(((Map)value).get(key)) || key.equals(p = JSONLDUtils.compactIRI(ctx, key, usedCtx)) && ((Map)rval).containsKey(p)) continue;
                ((Map)rval).put(p, this.compact(ctx, key, ((Map)value).get(key), usedCtx));
            }
        } else {
            String coerce = JSONLDUtils.getCoercionType(ctx, (String)property, usedCtx);
            String type = null;
            if (value instanceof Map) {
                if (!((Map)value).containsKey("@language")) {
                    type = ((Map)value).containsKey("@type") ? (String)((Map)value).get("@type") : (((Map)value).containsKey("@id") ? "@id" : coerce);
                }
            } else if (value instanceof String) {
                type = coerce;
            }
            if (coerce == null && ("http://www.w3.org/2001/XMLSchema#boolean".equals(type) || "http://www.w3.org/2001/XMLSchema#integer".equals(type) || "http://www.w3.org/2001/XMLSchema#double".equals(type))) {
                coerce = type;
            }
            if (coerce != null) {
                if (type == null) {
                    throw new RuntimeException("Cannot coerce type when a language is specified. The language information would be lost.");
                }
                if (!type.equals(coerce)) {
                    throw new RuntimeException("Cannot coerce type because the type does not match.");
                }
                if (value instanceof Map) {
                    if (((Map)value).containsKey("@id")) {
                        rval = ((Map)value).get("@id");
                    } else if (((Map)value).containsKey("@value")) {
                        rval = ((Map)value).get("@value");
                    }
                } else {
                    rval = value;
                }
                if ("http://www.w3.org/2001/XMLSchema#boolean".equals(coerce)) {
                    if (rval instanceof String) {
                        rval = "true".equals(rval);
                    } else if (rval instanceof Integer) {
                        rval = (Integer)rval != 0;
                    } else if (rval instanceof Double) {
                        rval = (Double)rval != 0.0;
                    } else if (rval instanceof Long) {
                        rval = (Long)rval != 0L;
                    } else if (rval instanceof Float) {
                        rval = ((Float)rval).floatValue() != 0.0f;
                    } else if (rval instanceof Short) {
                        rval = (Short)rval != 0;
                    } else if (!(rval instanceof Boolean)) {
                        rval = false;
                    }
                } else if ("http://www.w3.org/2001/XMLSchema#double".equals(coerce)) {
                    if (rval instanceof String) {
                        rval = Double.parseDouble((String)rval);
                    } else if (rval instanceof Number) {
                        rval = ((Number)rval).doubleValue();
                    }
                } else if ("http://www.w3.org/2001/XMLSchema#integer".equals(coerce)) {
                    if (rval instanceof String) {
                        rval = Integer.parseInt((String)rval);
                    } else if (rval instanceof Number) {
                        rval = ((Number)rval).intValue();
                    }
                }
            } else if (value instanceof Map) {
                rval = new HashMap();
                for (String key : ((Map)value).keySet()) {
                    ((Map)rval).put(keywords.get(key), ((Map)value).get(key));
                }
            } else {
                rval = JSONLDUtils.clone(value);
            }
            if ("@id".equals(type)) {
                if (rval instanceof Map) {
                    ((Map)rval).put(keywords.get("@id"), JSONLDUtils.compactIRI(ctx, (String)((Map)rval).get(keywords.get("@id")), usedCtx));
                } else {
                    rval = JSONLDUtils.compactIRI(ctx, (String)rval, usedCtx);
                }
            }
        }
        return rval;
    }

    public Object frame(Object input, Object frame) {
        return this.frame(input, frame, null);
    }

    public Object frame(Object input, Object frame, Map options) {
        ArrayList rval = null;
        input = this.normalize(input);
        Object ctx = null;
        if (frame instanceof Map && ((Map)((Object)frame)).containsKey("@context")) {
            ctx = JSONLDUtils.clone(((Map)((Object)frame)).get("@context"));
            frame = this.expand(frame);
        } else if (frame instanceof List && ((List)frame).size() > 0) {
            Object f0 = ((List)frame).get(0);
            if (f0 instanceof Map && ((Map)f0).containsKey("@context")) {
                ctx = JSONLDUtils.clone(((Map)f0).get("@context"));
            }
            ArrayList<Object> tmp = new ArrayList<Object>();
            for (Object f : (List)frame) {
                tmp.add(this.expand(f));
            }
            frame = tmp;
        }
        HashMap defaultOptions = new HashMap();
        HashMap<String, Boolean> tmpopts = new HashMap<String, Boolean>();
        tmpopts.put("embedOn", true);
        tmpopts.put("explicitOn", false);
        tmpopts.put("omitDefaultOn", false);
        defaultOptions.put("defaults", tmpopts);
        options = defaultOptions;
        HashMap<Object, Map<String, Object>> subjects = new HashMap<Object, Map<String, Object>>();
        for (Map<String, Object> map : input) {
            subjects.put(map.get("@id"), map);
        }
        rval = JSONLDUtils.frame(subjects, input, frame, new HashMap(), false, null, null, options);
        if (ctx != null && rval != null) {
            if (rval instanceof List) {
                List tmp = rval;
                rval = new ArrayList();
                for (Object i : tmp) {
                    ((List)rval).add(this.compact(ctx, i));
                }
            } else {
                rval = this.compact(ctx, rval);
            }
        }
        return rval;
    }

    public List<? extends Map<String, Object>> normalize(Object input) {
        ArrayList<Map<String, Object>> rval = new ArrayList<Map<String, Object>>();
        if (input != null) {
            Object expanded = this.expand(new HashMap<String, Object>(), null, input);
            this.nameBlankNodes(expanded);
            HashMap<String, Object> subjects = new HashMap<String, Object>();
            try {
                this.flatten(null, null, expanded, subjects);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.error("flatten failed!");
                return null;
            }
            for (String key : subjects.keySet()) {
                Map s = (Map)subjects.get(key);
                rval.add(s);
            }
            this.canonicalizeBlankNodes(rval);
            Collections.sort(rval, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> a, Map<String, Object> b) {
                    return JSONLDUtils.compare(a.get("@id"), b.get("@id"));
                }
            });
        }
        return rval;
    }

    public void triples(Object input, JSONLDTripleCallback tripleCallback) {
        List<? extends Map<String, Object>> normalized = this.normalize(input);
        if (tripleCallback == null) {
            // empty if block
        }
        ArrayList rval = new ArrayList();
        for (Map<String, Object> map : normalized) {
            String s = (String)map.get("@id");
            for (String p : map.keySet()) {
                ArrayList obj = map.get(p);
                if (p.equals("@id") || this.ignoredKeywords.contains(p)) continue;
                if (p.equals("@type")) {
                    p = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
                }
                if (!(obj instanceof List)) {
                    ArrayList tmp = new ArrayList();
                    tmp.add(obj);
                    obj = tmp;
                }
                for (Object o : (List)obj) {
                    if (o instanceof String) {
                        if (p.toString().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                            tripleCallback.triple(s, p, o.toString());
                            continue;
                        }
                        tripleCallback.triple(s, p, (String)o, "http://www.w3.org/2001/XMLSchema#string", null);
                        continue;
                    }
                    if (!(o instanceof Map)) continue;
                    if (((Map)o).containsKey("@value")) {
                        if (((Map)o).containsKey("@type")) {
                            String datatypeURI = (String)((Map)o).get("@type");
                            String value = (String)((Map)o).get("@value");
                            tripleCallback.triple(s, p, value, datatypeURI, null);
                            continue;
                        }
                        if (((Map)o).containsKey("@language")) {
                            tripleCallback.triple(s, p, (String)((Map)o).get("@value"), "http://www.w3.org/2001/XMLSchema#string", (String)((Map)o).get("@language"));
                            continue;
                        }
                        tripleCallback.triple(s, p, (String)((Map)o).get("@value"), "http://www.w3.org/2001/XMLSchema#string", null);
                        continue;
                    }
                    if (((Map)o).containsKey("@id")) {
                        tripleCallback.triple(s, p, (String)((Map)o).get("@id"));
                        continue;
                    }
                    return;
                }
            }
        }
    }

    public static void generateSimplifyContext(Object input, Map<String, Object> ctx) {
        block9: {
            block8: {
                if (!(input instanceof List)) break block8;
                for (Object o : (List)input) {
                    JSONLDProcessor.generateSimplifyContext(o, ctx);
                }
                break block9;
            }
            if (!(input instanceof Map)) break block9;
            Map o = (Map)input;
            for (String key : o.keySet()) {
                Object val;
                block7: {
                    val = o.get(key);
                    if (key.matches("^https?://.+$")) {
                        int idx = key.lastIndexOf(35);
                        if (idx < 0) {
                            idx = key.lastIndexOf(47);
                        }
                        String skey = key.substring(idx + 1);
                        Object keyval = key;
                        if (val instanceof Map && ((Map)val).containsKey("@id")) {
                            HashMap<String, String> tmp = new HashMap<String, String>();
                            tmp.put("@type", "@id");
                            tmp.put("@id", key);
                            keyval = tmp;
                        }
                        while (ctx.containsKey(skey)) {
                            if (!ctx.get(skey).equals(keyval)) {
                                skey = skey + "_";
                                continue;
                            }
                            break block7;
                        }
                        ctx.put(skey, keyval);
                    }
                }
                if (!(val instanceof Map) && !(val instanceof List)) continue;
                JSONLDProcessor.generateSimplifyContext(val, ctx);
            }
        }
    }

    public Object simplify(Map input) {
        Map origCtx = (Map)input.get("@context");
        Object expanded = this.expand(input);
        Map<String, Object> framectx = new HashMap<String, Object>();
        JSONLDProcessor.generateSimplifyContext(expanded, framectx);
        if (origCtx != null) {
            framectx = JSONLDUtils.mergeContexts(origCtx, framectx);
        }
        return this.compact(framectx, expanded);
    }

    private Map<String, Object> nestCore(Map<String, Object> rootObj, Map<String, Map<String, Object>> otherObjs) {
        HashMap<String, Object> rval = new HashMap<String, Object>();
        for (String key : rootObj.keySet()) {
            Object val = rootObj.get(key);
            if (this.ignoredKeywords.contains(key)) {
                rval.put(key, val);
                continue;
            }
            if (val instanceof List) {
                ArrayList<Map<String, Object>> lv = new ArrayList<Map<String, Object>>();
                for (Map o : (List)val) {
                    lv.add(this.nestCore(o, otherObjs));
                }
                rval.put(key, lv);
                continue;
            }
            if (val instanceof Map) {
                if (((Map)val).containsKey("@id") && otherObjs.containsKey(((Map)val).get("@id"))) {
                    rval.put(key, otherObjs.get(((Map)val).get("@id")));
                    continue;
                }
                rval.put(key, this.nestCore((Map)val, otherObjs));
                continue;
            }
            rval.put(key, val);
        }
        return rval;
    }

    public Object nest(List<Map<String, Object>> input, String rootObjId) {
        Map rootObj = null;
        Map rootObjCtx = null;
        HashMap<String, Map<String, Object>> otherObjs = new HashMap<String, Map<String, Object>>();
        for (Map<String, Object> item : input) {
            if (!item.containsKey("@id")) continue;
            if (rootObjId.equals(item.get("@id"))) {
                rootObjCtx = (Map)item.get("@context");
                rootObj = (Map)this.expand(item);
                continue;
            }
            otherObjs.put((String)item.get("@id"), (Map)this.expand(item));
        }
        if (rootObj == null) {
            return input;
        }
        HashMap<String, Map<String, Object>> nestedOthers = new HashMap<String, Map<String, Object>>();
        for (String key : otherObjs.keySet()) {
            Map val = (Map)otherObjs.get(key);
            nestedOthers.put(key, this.nestCore(val, otherObjs));
        }
        Map<String, Object> rval = this.nestCore(rootObj, nestedOthers);
        return this.compact(rootObjCtx != null ? rootObjCtx : new HashMap(), rval);
    }

    public void nameBlankNodes(Object input) {
        JSONLDUtils.NameGenerator ng;
        this.ngtmp = ng = new JSONLDUtils.NameGenerator("tmp");
        this.subjects = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> bnodes = new ArrayList<Map<String, Object>>();
        this.collectSubjects(input, this.subjects, bnodes);
        for (Map map : bnodes) {
            if (map.containsKey("@id")) continue;
            while (this.subjects.containsKey(ng.next())) {
            }
            map.put("@id", ng.current());
            this.subjects.put(ng.current(), map);
        }
    }

    private void flatten(Object parent, String parentProperty, Object value, Map<String, Object> subjects) throws Exception {
        HashMap flattened = null;
        if (value != null) {
            if (value instanceof List) {
                for (Object v : (List)((Object)value)) {
                    this.flatten(parent, parentProperty, v, subjects);
                }
            } else if (value instanceof Map) {
                Map mapVal = value;
                if (mapVal.containsKey("@value") || "@type".equals(parentProperty)) {
                    flattened = JSONLDUtils.clone(value);
                } else if (mapVal.get("@id") instanceof List) {
                    if (parent != null) {
                        throw new Exception("Embedded graph literals cannot be flattened");
                    }
                    for (Object key : (List)mapVal.get("@id")) {
                        if (this.ignoredKeywords.contains(key)) continue;
                        this.flatten(parent, parentProperty, key, subjects);
                    }
                } else {
                    Object subject;
                    if (subjects.containsKey(mapVal.get("@id"))) {
                        subject = subjects.get(mapVal.get("@id"));
                    } else {
                        subject = new HashMap();
                        ((Map)subject).put("@id", mapVal.get("@id"));
                        subjects.put((String)mapVal.get("@id"), subject);
                    }
                    flattened = new HashMap();
                    ((Map)flattened).put("@id", ((Map)subject).get("@id"));
                    for (String key : mapVal.keySet()) {
                        Object v = mapVal.get(key);
                        if (this.ignoredKeywords.contains(key)) {
                            ((Map)subject).put(key, v);
                            continue;
                        }
                        if (v == null || "@id".equals(key)) continue;
                        if (((Map)subject).containsKey(key)) {
                            if (!(((Map)subject).get(key) instanceof List)) {
                                Object tmp = ((Map)subject).get(key);
                                ArrayList lst = new ArrayList();
                                lst.add(tmp);
                                ((Map)subject).put(key, lst);
                            }
                        } else {
                            ArrayList lst = new ArrayList();
                            ((Map)subject).put(key, lst);
                        }
                        this.flatten(((Map)subject).get(key), key, v, subjects);
                        if (((List)((Map)subject).get(key)).size() != 1) continue;
                        ((Map)subject).put(key, ((List)((Map)subject).get(key)).get(0));
                    }
                }
            } else {
                flattened = value;
            }
        }
        if (flattened != null && parent != null) {
            if (parent instanceof List) {
                boolean duplicate = false;
                for (Object e : (List)parent) {
                    if (JSONLDUtils.compareObjects(e, flattened) != 0) continue;
                    duplicate = true;
                    break;
                }
                if (!duplicate) {
                    ((List)parent).add(flattened);
                }
            } else {
                ((Map)parent).put(parentProperty, flattened);
            }
        }
    }

    private void collectEdges() {
        ArrayList bnodes;
        List all;
        Map refs = (Map)this.edges.get("refs");
        Map props = (Map)this.edges.get("props");
        for (String iri : this.subjects.keySet()) {
            Map subject = (Map)this.subjects.get(iri);
            for (String key : subject.keySet()) {
                if (key.equals("@id") || this.ignoredKeywords.contains(key)) continue;
                Object object = subject.get(key);
                ArrayList tmp = null;
                if (object instanceof List) {
                    tmp = (ArrayList)object;
                } else {
                    tmp = new ArrayList();
                    tmp.add(object);
                }
                for (Object o : tmp) {
                    if (!(o instanceof Map) || !((Map)o).containsKey("@id") || !this.subjects.containsKey(((Map)o).get("@id"))) continue;
                    Object objIri = ((Map)o).get("@id");
                    HashMap<String, String> tmp1 = new HashMap<String, String>();
                    tmp1.put("s", iri);
                    tmp1.put("p", key);
                    ((List)((Map)refs.get(objIri)).get("all")).add(tmp1);
                    tmp1 = new HashMap();
                    tmp1.put("s", (String)objIri);
                    tmp1.put("p", key);
                    ((List)((Map)props.get(iri)).get("all")).add(tmp1);
                }
            }
        }
        Comparator<Object> edgesCmp = new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                return JSONLDProcessor.this.compareEdges(a, b);
            }
        };
        for (String iri : refs.keySet()) {
            all = (List)((Map)refs.get(iri)).get("all");
            Collections.sort(all, edgesCmp);
            bnodes = new ArrayList();
            for (Object edge : all) {
                if (!JSONLDUtils.isBlankNodeIri(((Map)edge).get("s"))) continue;
                bnodes.add(edge);
            }
            ((Map)refs.get(iri)).put("bnodes", bnodes);
        }
        for (String iri : props.keySet()) {
            all = (List)((Map)props.get(iri)).get("all");
            Collections.sort(all, edgesCmp);
            bnodes = new ArrayList();
            for (Object edge : all) {
                if (!JSONLDUtils.isBlankNodeIri(((Map)edge).get("s"))) continue;
                bnodes.add(edge);
            }
            ((Map)props.get(iri)).put("bnodes", bnodes);
        }
    }

    public void canonicalizeBlankNodes(List<Map<String, Object>> input) {
        this.renamed = new HashMap<String, Object>();
        this.serializations = new HashMap<String, Object>();
        this.edges = new HashMap<String, Object>();
        this.edges.put("refs", new HashMap());
        this.edges.put("props", new HashMap());
        this.subjects = new HashMap<String, Object>();
        ArrayList<Map> bnodes = new ArrayList<Map>();
        for (Map<String, Object> s : input) {
            String iri = (String)s.get("@id");
            this.subjects.put(iri, s);
            Map refs = (Map)this.edges.get("refs");
            HashMap tmp = new HashMap();
            tmp.put("all", new ArrayList());
            tmp.put("bnodes", new ArrayList());
            refs.put(iri, tmp);
            Map props = (Map)this.edges.get("props");
            tmp = new HashMap();
            tmp.put("all", new ArrayList());
            tmp.put("bnodes", new ArrayList());
            props.put(iri, tmp);
            if (!JSONLDUtils.isBlankNodeIri(iri)) continue;
            bnodes.add(s);
        }
        this.collectEdges();
        JSONLDUtils.NameGenerator c14n = this.ngc14n = new JSONLDUtils.NameGenerator("c14n");
        JSONLDUtils.NameGenerator ngTmp = this.ngtmp;
        for (Map bnode : bnodes) {
            String iri = (String)bnode.get("@id");
            if (c14n.inNamespace(iri)) {
                while (this.subjects.containsKey(ngTmp.next())) {
                }
                this.renameBlankNode(bnode, ngTmp.current());
                iri = (String)bnode.get("@id");
            }
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            tmp.put("props", null);
            tmp.put("refs", null);
            this.serializations.put(iri, tmp);
        }
        Comparator<Map<String, Object>> bnodeSort = new Comparator<Map<String, Object>>(){
            private JSONLDProcessor processor;

            public Comparator<Map<String, Object>> setProcessor(JSONLDProcessor p) {
                this.processor = p;
                return this;
            }

            @Override
            public int compare(Map<String, Object> a, Map<String, Object> b) {
                int rval = this.processor.deepCompareBlankNodes(a, b);
                return rval;
            }
        }.setProcessor(this);
        boolean resort = true;
        while (bnodes.size() > 0) {
            if (resort) {
                resort = false;
                Collections.sort(bnodes, bnodeSort);
            }
            Map bnode = (Map)bnodes.get(0);
            bnodes.remove(0);
            String iri = (String)bnode.get("@id");
            resort = this.serializations.containsKey(iri) && ((Map)this.serializations.get(iri)).get("props") != null;
            Map<String, Object> mapping = null;
            for (String dir : new String[]{"props", "refs"}) {
                if (this.serializations.containsKey(iri) && ((Map)this.serializations.get(iri)).containsKey(dir) && ((Map)this.serializations.get(iri)).get(dir) != null) {
                    mapping = (Map)((Map)((Map)this.serializations.get(iri)).get(dir)).get("m");
                } else {
                    mapping = new HashMap<String, Object>();
                    mapping.put(iri, "s1");
                }
                ArrayList keys = new ArrayList(mapping.keySet());
                Collections.sort(keys, new Comparator<String>(){
                    private Map<String, Object> mapping;

                    public Comparator<String> setMapping(Map<String, Object> m) {
                        this.mapping = m;
                        return this;
                    }

                    @Override
                    public int compare(String a, String b) {
                        return JSONLDUtils.compare(this.mapping.get(a), this.mapping.get(b));
                    }
                }.setMapping(mapping));
                ArrayList<String> renamed = new ArrayList<String>();
                for (String iriK : keys) {
                    if (c14n.inNamespace(iri) || !this.subjects.containsKey(iriK)) continue;
                    this.renameBlankNode((Map)this.subjects.get(iriK), c14n.next());
                    renamed.add(iriK);
                }
                ArrayList<Map> tmp = bnodes;
                bnodes = new ArrayList();
                for (Map b : tmp) {
                    String iriB = (String)b.get("@id");
                    if (c14n.inNamespace(iriB)) continue;
                    for (String i2 : renamed) {
                        if (!this.markSerializationDirty(iriB, i2, dir)) continue;
                        resort = true;
                    }
                    bnodes.add(b);
                }
            }
        }
        for (String key : ((Map)this.edges.get("props")).keySet()) {
            if (((List)((Map)((Map)this.edges.get("props")).get(key)).get("bnodes")).size() <= 0) continue;
            Map bnode = (Map)this.subjects.get(key);
            for (String p : bnode.keySet()) {
                if (p.startsWith("@") || !(bnode.get(p) instanceof List)) continue;
                Collections.sort((List)bnode.get(p), new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return JSONLDUtils.compareObjects(o1, o2);
                    }
                });
            }
        }
    }

    private boolean markSerializationDirty(String iri, Object changed, String dir) {
        boolean rval = false;
        Object s = this.serializations.get(iri);
        if (((Map)s).containsKey(dir) && ((Map)s).get(dir) != null && ((Map)((Map)((Map)s).get(dir)).get("m")).containsKey(changed)) {
            ((Map)s).put(dir, null);
            rval = true;
        }
        return rval;
    }

    private void renameBlankNode(Map<String, Object> b, String id) {
        String old = (String)b.get("@id");
        b.put("@id", id);
        this.subjects.put(id, this.subjects.get(old));
        this.subjects.remove(old);
        ((Map)this.edges.get("refs")).put(id, ((Map)this.edges.get("refs")).get(old));
        ((Map)this.edges.get("props")).put(id, ((Map)this.edges.get("props")).get(old));
        ((Map)this.edges.get("refs")).remove(old);
        ((Map)this.edges.get("props")).remove(old);
        List refs = (List)((Map)((Map)this.edges.get("refs")).get(id)).get("all");
        for (Map i : refs) {
            String iri = (String)i.get("s");
            if (iri.equals(old)) {
                iri = id;
            }
            Map ref = (Map)this.subjects.get(iri);
            List props = (List)((Map)((Map)this.edges.get("props")).get(iri)).get("all");
            for (Map i2 : props) {
                if (!old.equals(i2.get("s"))) continue;
                i2.put("s", id);
                String p = (String)i2.get("p");
                List tmp = null;
                if (ref.get(p) instanceof Map) {
                    tmp = new ArrayList();
                    tmp.add(ref.get(p));
                } else {
                    tmp = ref.get(p) instanceof List ? (List)ref.get(p) : new ArrayList();
                }
                for (Object n : tmp) {
                    if (!(n instanceof Map) || !((Map)n).containsKey("@id") || !old.equals(((Map)n).get("@id"))) continue;
                    ((Map)n).put("@id", id);
                }
            }
        }
        List props = (List)((Map)((Map)this.edges.get("props")).get(id)).get("all");
        for (Map i : props) {
            String iri = (String)i.get("s");
            refs = (List)((Map)((Map)this.edges.get("refs")).get(iri)).get("all");
            for (Map r : refs) {
                if (!old.equals(r.get("s"))) continue;
                r.put("s", id);
            }
        }
    }

    private int deepCompareBlankNodes(Map<String, Object> a, Map<String, Object> b) {
        String iriB;
        int rval = 0;
        String iriA = (String)a.get("@id");
        if (iriA.equals(iriB = (String)b.get("@id"))) {
            rval = 0;
        } else {
            rval = this.shallowCompareBlankNodes(a, b);
            if (rval == 0) {
                String[] dirs = new String[]{"props", "refs"};
                for (int i = 0; rval == 0 && i < dirs.length; ++i) {
                    MappingBuilder mb;
                    String dir = dirs[i];
                    Map sA = (Map)this.serializations.get(iriA);
                    Map sB = (Map)this.serializations.get(iriB);
                    if (sA.get(dir) == null) {
                        mb = new MappingBuilder();
                        if (dir.equals("refs")) {
                            mb.mapping = (Map)JSONLDUtils.clone(((Map)sA.get("props")).get("m"));
                            mb.count = mb.mapping.size() + 1;
                        }
                        this.serializeBlankNode(sA, iriA, mb, dir);
                    }
                    if (sB.get(dir) == null) {
                        mb = new MappingBuilder();
                        if (dir.equals("refs")) {
                            mb.mapping = (Map)JSONLDUtils.clone(((Map)sB.get("props")).get("m"));
                            mb.count = mb.mapping.size() + 1;
                        }
                        this.serializeBlankNode(sB, iriB, mb, dir);
                    }
                    rval = JSONLDUtils.compare(((Map)sA.get(dir)).get("s"), ((Map)sB.get(dir)).get("s"));
                }
            }
        }
        return rval;
    }

    private void serializeBlankNode(Map<String, Object> s, String iri, MappingBuilder mb, String dir) {
        if (!mb.processed.containsKey(iri)) {
            mb.processed.put(iri, true);
            String siri = mb.mapNode(iri);
            MappingBuilder original = mb.copy();
            List adj = (List)((Map)((Map)this.edges.get(dir)).get(iri)).get("bnodes");
            HashMap<String, Object> mapped = new HashMap<String, Object>();
            ArrayList<Object> notMapped = new ArrayList<Object>();
            for (Object i : adj) {
                if (mb.mapping.containsKey(((Map)i).get("s"))) {
                    mapped.put(mb.mapping.get(((Map)i).get("s")), ((Map)i).get("s"));
                    continue;
                }
                notMapped.add(i);
            }
            int combos = Math.max(1, notMapped.size());
            for (int i = 0; i < combos; ++i) {
                MappingBuilder m = i == 0 ? mb : original.copy();
                this.serializeCombos(s, iri, siri, mb, dir, mapped, notMapped);
            }
        }
    }

    private void serializeCombos(Map<String, Object> s, String iri, String siri, MappingBuilder mb, String dir, Map<String, Object> mapped, List<Object> notMapped) {
        if (notMapped.size() > 0) {
            mapped = (Map)JSONLDUtils.clone(mapped);
            mapped.put(mb.mapNode((String)((Map)notMapped.get(0)).get("s")), ((Map)notMapped.get(0)).get("s"));
            MappingBuilder original = mb.copy();
            notMapped.remove(0);
            int rotations = Math.max(1, notMapped.size());
            for (int r = 0; r < rotations; ++r) {
                MappingBuilder m = r == 0 ? mb : original.copy();
                this.serializeCombos(s, iri, siri, m, dir, mapped, notMapped);
                JSONLDUtils.rotate(notMapped);
            }
        } else {
            ArrayList keys = new ArrayList(mapped.keySet());
            Collections.sort(keys);
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            tmp.put("i", iri);
            tmp.put("k", keys);
            tmp.put("m", mapped);
            mb.adj.put(siri, tmp);
            mb.serialize(this.subjects, this.edges);
            if (s.get(dir) == null || JSONLDUtils.compareSerializations(mb.s, (String)((Map)s.get(dir)).get("s")) <= 0) {
                for (String k : keys) {
                    this.serializeBlankNode(s, (String)mapped.get(k), mb, dir);
                }
                mb.serialize(this.subjects, this.edges);
                if (s.get(dir) == null || JSONLDUtils.compareSerializations(mb.s, (String)((Map)s.get(dir)).get("s")) <= 0 && mb.s.length() >= ((String)((Map)s.get(dir)).get("s")).length()) {
                    tmp = new HashMap();
                    tmp.put("s", mb.s);
                    tmp.put("m", mb.mapping);
                    s.put(dir, tmp);
                }
            }
        }
    }

    private int shallowCompareBlankNodes(Map<String, Object> a, Map<String, Object> b) {
        int rval = 0;
        ArrayList<String> pA = new ArrayList<String>();
        pA.addAll(a.keySet());
        ArrayList<String> pB = new ArrayList<String>();
        pB.addAll(b.keySet());
        rval = JSONLDUtils.compare(pA.size(), pB.size());
        if (rval == 0) {
            Collections.sort(pA);
            Collections.sort(pB);
            rval = JSONLDUtils.compare(pA, pB);
        }
        if (rval == 0) {
            rval = JSONLDUtils.compareBlankNodeObjects(a, b);
        }
        if (rval == 0) {
            List edgesA = (List)((Map)((Map)this.edges.get("refs")).get(a.get("@id"))).get("all");
            List edgesB = (List)((Map)((Map)this.edges.get("refs")).get(b.get("@id"))).get("all");
            rval = JSONLDUtils.compare(edgesA.size(), edgesB.size());
            if (rval == 0) {
                for (int i = 0; i < edgesA.size() && rval == 0; ++i) {
                    rval = this.compareEdges(edgesA.get(i), edgesB.get(i));
                }
            }
        }
        return rval;
    }

    private int compareEdges(Object a, Object b) {
        int rval = 0;
        boolean bnodeA = JSONLDUtils.isBlankNodeIri(((Map)a).get("s"));
        boolean bnodeB = JSONLDUtils.isBlankNodeIri(((Map)b).get("s"));
        JSONLDUtils.NameGenerator c14n = this.ngc14n;
        if (bnodeA != bnodeB) {
            rval = bnodeA ? 1 : -1;
        } else {
            if (!bnodeA) {
                rval = JSONLDUtils.compare(((Map)a).get("s"), ((Map)b).get("s"));
            }
            if (rval == 0) {
                rval = JSONLDUtils.compare(((Map)a).get("p"), ((Map)b).get("p"));
            }
            if (rval == 0 && c14n != null) {
                boolean c14nB;
                boolean c14nA = c14n.inNamespace((String)((Map)a).get("s"));
                if (c14nA != (c14nB = c14n.inNamespace((String)((Map)b).get("s")))) {
                    rval = c14nA ? 1 : -1;
                } else if (c14nA) {
                    rval = JSONLDUtils.compare(((Map)a).get("s"), ((Map)b).get("s"));
                }
            }
        }
        return rval;
    }

    private void collectSubjects(Object input, Map<String, Object> subjects, List<Map<String, Object>> bnodes) {
        block10: {
            block9: {
                if (input == null) {
                    return;
                }
                if (!(input instanceof List)) break block9;
                for (Object o : (List)input) {
                    this.collectSubjects(o, subjects, bnodes);
                }
                break block10;
            }
            if (!(input instanceof Map)) break block10;
            if (((Map)input).containsKey("@id")) {
                Object id = ((Map)input).get("@id");
                if (id instanceof List) {
                    this.collectSubjects(id, subjects, bnodes);
                } else if (JSONLDUtils.isSubject(input)) {
                    subjects.put((String)id, input);
                }
            } else if (JSONLDUtils.isBlankNode(input)) {
                bnodes.add((Map)input);
            }
            for (String key : ((Map)input).keySet()) {
                if (this.ignoredKeywords.contains(key)) continue;
                this.collectSubjects(((Map)input).get(key), subjects, bnodes);
            }
        }
    }

    private class MappingBuilder {
        public HashMap<String, Boolean> done;
        public ArrayList<Object> keyStack;
        public String s;
        public Map<String, Object> adj;
        public Map<String, Boolean> processed = new HashMap<String, Boolean>();
        public int count = 1;
        public Map<String, String> mapping = new HashMap<String, String>();

        public MappingBuilder() {
            this.adj = new HashMap<String, Object>();
            this.keyStack = new ArrayList();
            HashMap<String, Serializable> t1 = new HashMap<String, Serializable>();
            ArrayList<String> t2 = new ArrayList<String>();
            t2.add("s1");
            t1.put("keys", t2);
            t1.put("idx", Integer.valueOf(0));
            this.keyStack.add(t1);
            this.done = new HashMap();
            this.s = "";
        }

        public String mapNode(String iri) {
            if (!this.mapping.containsKey(iri)) {
                if (iri.startsWith("_:c14n")) {
                    this.mapping.put(iri, "c" + iri.substring(6));
                } else {
                    this.mapping.put(iri, "s" + this.count);
                    ++this.count;
                }
            }
            return this.mapping.get(iri);
        }

        public void serialize(Map<String, Object> subjects, Map<String, Object> edges) {
            if (this.keyStack.size() > 0) {
                Map next = (Map)this.keyStack.remove(this.keyStack.size() - 1);
                while ((Integer)next.get("idx") < ((List)next.get("keys")).size()) {
                    String k = (String)((List)next.get("keys")).get((Integer)next.get("idx"));
                    if (!this.adj.containsKey(k)) {
                        this.keyStack.add(next);
                        break;
                    }
                    next.put("idx", (Integer)next.get("idx") + 1);
                    if (this.done.containsKey(k)) {
                        this.s = this.s + "_" + k;
                        continue;
                    }
                    this.done.put(k, true);
                    String s = k;
                    Map adj = (Map)this.adj.get(k);
                    String iri = (String)adj.get("i");
                    if (subjects.containsKey(iri)) {
                        Map b = (Map)subjects.get(iri);
                        s = s + "[" + JSONLDUtils.serializeProperties(b) + "]";
                        Boolean first = true;
                        s = s + "[";
                        List refs = (List)((Map)((Map)edges.get("refs")).get(iri)).get("all");
                        for (Map r : refs) {
                            if (first.booleanValue()) {
                                first = false;
                            } else {
                                s = s + "|";
                            }
                            s = s + "<" + r.get("p") + ">";
                            s = s + (JSONLDUtils.isBlankNodeIri(r.get("s")) ? "_:" : "<" + r.get("s") + ">");
                        }
                        s = s + "]";
                    }
                    for (String o : (List)adj.get("k")) {
                        s = s + o;
                    }
                    this.s = this.s + s;
                    HashMap tmp = new HashMap();
                    tmp.put("keys", adj.get("k"));
                    tmp.put("idx", 0);
                    this.keyStack.add(tmp);
                    this.serialize(subjects, edges);
                }
            }
        }

        public MappingBuilder copy() {
            MappingBuilder rval = new MappingBuilder();
            rval.count = this.count;
            rval.processed = (Map)JSONLDUtils.clone(this.processed);
            rval.mapping = (Map)JSONLDUtils.clone(this.mapping);
            rval.adj = (Map)JSONLDUtils.clone(this.adj);
            rval.keyStack = (ArrayList)JSONLDUtils.clone(this.keyStack);
            rval.done = (HashMap)JSONLDUtils.clone(this.done);
            rval.s = this.s;
            return rval;
        }
    }
}

