/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.reasoner.webservices;

import info.aduna.iteration.Iterations;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.marmotta.kiwi.model.rdf.KiWiLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiTriple;
import org.apache.marmotta.kiwi.reasoner.model.program.Justification;
import org.apache.marmotta.kiwi.reasoner.model.program.Rule;
import org.apache.marmotta.platform.reasoner.services.ReasoningSailProvider;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;

@ApplicationScoped
@Path(value="/reasoner/engine")
@Produces(value={"application/json"})
public class ReasonerWebService {
    @Inject
    private Logger log;
    @Inject
    private ReasoningSailProvider provider;

    @POST
    @Path(value="/run")
    @Produces(value={"text/plain"})
    public Response rerunPrograms() throws Exception {
        this.log.debug("rerunning all reasoning programs");
        this.provider.reRunPrograms();
        return Response.ok((Object)"(re-)reasoning triggered").build();
    }

    @GET
    @Path(value="/justify")
    public Response justifyTriple(@QueryParam(value="id") Long tripleId) {
        if (tripleId != null) {
            try {
                StringBuilder result = new StringBuilder();
                List justifications = Iterations.asList(this.provider.justify(tripleId));
                HashMap<KiWiTriple, HashSet<Justification>> grouped = new HashMap<KiWiTriple, HashSet<Justification>>();
                for (Justification j : justifications) {
                    HashSet<Justification> tjs = (HashSet<Justification>)grouped.get(j.getTriple());
                    if (tjs == null) {
                        tjs = new HashSet<Justification>();
                        grouped.put(j.getTriple(), tjs);
                    }
                    tjs.add(j);
                }
                result.append("[");
                Iterator it = grouped.keySet().iterator();
                while (it.hasNext()) {
                    KiWiTriple t = (KiWiTriple)it.next();
                    result.append(this.formatJSON(t, (Collection)grouped.get(t)));
                    if (it.hasNext()) {
                        result.append(",\n");
                        continue;
                    }
                    result.append("\n");
                }
                result.append("]");
                return Response.ok((Object)result.toString()).build();
            }
            catch (SailException e) {
                return Response.serverError().entity((Object)e.getMessage()).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"no triple id given").build();
    }

    private String formatJSON(KiWiTriple triple, Collection<Justification> justifications) {
        StringBuilder result = new StringBuilder();
        result.append("{\n ");
        result.append("\"triple\": " + this.formatJSON(triple) + ",\n");
        result.append("\"justifications\": [\n");
        Iterator<Justification> justs = justifications.iterator();
        while (justs.hasNext()) {
            Justification justification = justs.next();
            result.append("  {\n");
            result.append("    \"triples\": [\n");
            Iterator it = justification.getSupportingTriples().iterator();
            while (it.hasNext()) {
                KiWiTriple t = (KiWiTriple)it.next();
                result.append("      " + this.formatJSON(t));
                if (it.hasNext()) {
                    result.append(",\n");
                    continue;
                }
                result.append("\n");
            }
            result.append("    ],");
            result.append("    \"rules\": [\n");
            it = justification.getSupportingRules().iterator();
            while (it.hasNext()) {
                Rule r = (Rule)it.next();
                result.append("      \"" + r.toString().replace("\"", "'") + "\"");
                if (it.hasNext()) {
                    result.append(",\n");
                    continue;
                }
                result.append("\n");
            }
            result.append("    ]");
            result.append("  }");
            if (justs.hasNext()) {
                result.append(",\n");
                continue;
            }
            result.append("\n");
        }
        result.append("]");
        result.append("}");
        return result.toString();
    }

    private String formatJSON(KiWiTriple triple) {
        return "{ " + this.formatJSON((KiWiNode)triple.getSubject(), false) + " : { " + this.formatJSON((KiWiNode)triple.getPredicate(), false) + " : [" + this.formatJSON(triple.getObject(), true) + "] } }";
    }

    private String formatJSON(KiWiNode node, boolean asObject) {
        if (node.isUriResource()) {
            String result = "\"" + node.stringValue() + "\"";
            if (asObject) {
                return "{  \"type\" : \"uri\", \"value\" : " + result + " }";
            }
            return result;
        }
        if (node.isAnonymousResource()) {
            String result = "\"_:" + node.stringValue() + "\"";
            if (asObject) {
                return "{  \"type\" : \"bnode\", \"value\" : " + result + " }";
            }
            return result;
        }
        if (node.isLiteral()) {
            KiWiLiteral l = (KiWiLiteral)node;
            return "{ \"type\" : \"literal\", \"value\" : \"" + l.getContent().replace("\"", "\\\"") + "\"" + (l.getLocale() != null ? ", \"lang\" : \"" + l.getLocale().getLanguage() + "\"" : "") + (l.getType() != null ? ", \"type\" : \"" + l.getType() + "\"" : "") + " }";
        }
        return null;
    }
}

