/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.model.transformers.StringTransformer;
import org.apache.marmotta.ldpath.util.Collections;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssSelectFunction<KiWiNode>
extends SelectorFunction<KiWiNode> {
    private Logger log = LoggerFactory.getLogger(CssSelectFunction.class);
    private final StringTransformer<KiWiNode> transformer = new StringTransformer();

    public Collection<KiWiNode> apply(RDFBackend<KiWiNode> rdfBackend, KiWiNode context, Collection<KiWiNode> ... args) throws IllegalArgumentException {
        Iterator<KiWiNode> it;
        if (args.length < 1) {
            throw new IllegalArgumentException("CSS-Selector is required as first argument.");
        }
        HashSet<String> jsoupSelectors = new HashSet<String>();
        for (KiWiNode xpath : args[0]) {
            try {
                jsoupSelectors.add((String)this.transformer.transform((RDFBackend)rdfBackend, (Object)xpath, (Map)null));
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("First argument must not contain anything else than String-Literals!");
            }
        }
        if (args.length < 2) {
            this.log.debug("Use context {} to apply css-selector {}", context, jsoupSelectors);
            it = java.util.Collections.singleton(context).iterator();
        } else {
            this.log.debug("apply css-selector {} on parsed parameters", jsoupSelectors);
            it = Collections.iterator((int)1, (Collection[])args);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        while (it.hasNext()) {
            KiWiNode n = it.next();
            try {
                Object string = this.transformer.transform((RDFBackend)rdfBackend, (Object)n, (Map)null);
                Document jsoup = Jsoup.parse((String)string);
                if (rdfBackend.isURI(context)) {
                    jsoup.setBaseUri(rdfBackend.stringValue(context));
                }
                for (String r : this.doFilter(jsoup, jsoupSelectors)) {
                    result.add(rdfBackend.createLiteral(r));
                }
            }
            catch (IOException e) {
            }
        }
        return result;
    }

    private LinkedList<String> doFilter(Document jsoup, Set<String> jsoupSelectors) throws IOException {
        LinkedList<String> result = new LinkedList<String>();
        for (String jsoupSel : jsoupSelectors) {
            try {
                for (Element e : jsoup.select(jsoupSel)) {
                    result.add(e.outerHtml());
                }
            }
            catch (Selector.SelectorParseException xpe) {
                throw new IllegalArgumentException("error while processing jsoup selector: '" + jsoupSel + "'", xpe);
            }
        }
        return result;
    }

    public String getLocalName() {
        return "css";
    }

    public String getSignature() {
        return "fn:css(jsoup: String [, nodes: XMLLiteralList]) : LiteralList";
    }

    public String getDescription() {
        return "Evaluate an JSoup CSS selector on either the value of the context node or the values of the nodes passed as arguments.";
    }
}

