/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import javax.security.auth.login.Configuration;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.ZooKeeperTestHarness$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.IntegrationTest;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Category(value={IntegrationTest.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Uf!\u0002\u0012$\u0003\u0003A\u0003\"B\u001d\u0001\t\u0003Q\u0004bB\u001f\u0001\u0005\u0004%\tA\u0010\u0005\u0007\u000b\u0002\u0001\u000b\u0011B \t\u000f\u0019\u0003!\u0019!C\u0001}!1q\t\u0001Q\u0001\n}Bq\u0001\u0013\u0001C\u0002\u0013\u0005a\b\u0003\u0004J\u0001\u0001\u0006Ia\u0010\u0005\u0006\u0015\u0002!\tb\u0013\u0005\b%\u0002\u0001\r\u0011\"\u0001T\u0011\u001d9\u0006\u00011A\u0005\u0002aCaA\u0018\u0001!B\u0013!\u0006bB0\u0001\u0001\u0004%\t\u0001\u0019\u0005\bI\u0002\u0001\r\u0011\"\u0001f\u0011\u00199\u0007\u0001)Q\u0005C\"9\u0001\u000e\u0001a\u0001\n\u0003I\u0007bB7\u0001\u0001\u0004%\tA\u001c\u0005\u0007a\u0002\u0001\u000b\u0015\u00026\t\u000bE\u0004A\u0011\u0001 \t\u000bI\u0004A\u0011A:\t\r}\u0004A\u0011AA\u0001\u0011\u001d\ty\u0001\u0001C\u0001\u0003\u0003Aq!!\u0007\u0001\t\u0003\tYbB\u0004\u0002V\rB\t!a\u0016\u0007\r\t\u001a\u0003\u0012AA-\u0011\u0019I\u0004\u0004\"\u0001\u0002h!I\u0011\u0011\u000e\rC\u0002\u0013\u0005\u00111\u000e\u0005\t\u0003wB\u0002\u0015!\u0003\u0002n!I\u0011Q\u0010\rC\u0002\u0013\u0005\u0011q\u0010\u0005\t\u0003\u001bC\u0002\u0015!\u0003\u0002\u0002\"9\u0011q\u0012\r\u0005\u0002\u0005\u0005\u0001bBAM1\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003GCB\u0011AAS\u0011%\tY\u000bGA\u0001\n\u0013\tiK\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0006\u0003I\u0015\n!A_6\u000b\u0003\u0019\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001SM\u0002\"AK\u0019\u000e\u0003-R!\u0001L\u0017\u0002\u000b),h.\u001b;\u000b\u00059z\u0013!C:dC2\fG/Z:u\u0015\u0005\u0001\u0014aA8sO&\u0011!g\u000b\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007C\u0001\u001b8\u001b\u0005)$B\u0001\u001c&\u0003\u0015)H/\u001b7t\u0013\tATGA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005Y\u0004C\u0001\u001f\u0001\u001b\u0005\u0019\u0013a\u0005>l\u0007>tg.Z2uS>tG+[7f_V$X#A \u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\u0007%sG/\u0001\u000b{W\u000e{gN\\3di&|g\u000eV5nK>,H\u000fI\u0001\u0011u.\u001cVm]:j_:$\u0016.\\3pkR\f\u0011C_6TKN\u001c\u0018n\u001c8US6,w.\u001e;!\u0003UQ8.T1y\u0013:4E.[4iiJ+\u0017/^3tiN\faC_6NCbLeN\u00127jO\"$(+Z9vKN$8\u000fI\u0001\u000eu.\f5\r\\:F]\u0006\u0014G.\u001a3\u0016\u00031\u00032\u0001Q'P\u0013\tq\u0015I\u0001\u0004PaRLwN\u001c\t\u0003\u0001BK!!U!\u0003\u000f\t{w\u000e\\3b]\u0006A!p[\"mS\u0016tG/F\u0001U!\taT+\u0003\u0002WG\ti1*\u00194lCj[7\t\\5f]R\fAB_6DY&,g\u000e^0%KF$\"!\u0017/\u0011\u0005\u0001S\u0016BA.B\u0005\u0011)f.\u001b;\t\u000fuS\u0011\u0011!a\u0001)\u0006\u0019\u0001\u0010J\u0019\u0002\u0013i\\7\t\\5f]R\u0004\u0013!D1e[&t'l[\"mS\u0016tG/F\u0001b!\ta$-\u0003\u0002dG\ti\u0011\tZ7j]j[7\t\\5f]R\f\u0011#\u00193nS:T6n\u00117jK:$x\fJ3r)\tIf\rC\u0004^\u001b\u0005\u0005\t\u0019A1\u0002\u001d\u0005$W.\u001b8[W\u000ec\u0017.\u001a8uA\u0005I!p\\8lK\u0016\u0004XM]\u000b\u0002UB\u0011Ah[\u0005\u0003Y\u000e\u0012\u0011#R7cK\u0012$W\r\u001a.p_.,W\r]3s\u00035Qxn\\6fKB,'o\u0018\u0013fcR\u0011\u0011l\u001c\u0005\b;B\t\t\u00111\u0001k\u0003)Qxn\\6fKB,'\u000fI\u0001\u0007u.\u0004vN\u001d;\u0002\u0013i\\7i\u001c8oK\u000e$X#\u0001;\u0011\u0005UdhB\u0001<{!\t9\u0018)D\u0001y\u0015\tIx%\u0001\u0004=e>|GOP\u0005\u0003w\u0006\u000ba\u0001\u0015:fI\u00164\u0017BA?\u007f\u0005\u0019\u0019FO]5oO*\u001110Q\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00023\"\u001aA#!\u0002\u0011\t\u0005\u001d\u00111B\u0007\u0003\u0003\u0013Q!\u0001L\u0018\n\t\u00055\u0011\u0011\u0002\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D3!FA\n!\u0011\t9!!\u0006\n\t\u0005]\u0011\u0011\u0002\u0002\u0006\u0003\u001a$XM]\u0001,GJ,\u0017\r^3[_>\\U-\u001a9fe\u000ec\u0017.\u001a8u)>$&/[4hKJ\u001cVm]:j_:,\u0005\u0010]5ssR!\u0011QDA\u0016!\u0011\ty\"a\n\u000e\u0005\u0005\u0005\"b\u00015\u0002$)\u0019\u0011QE\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\tI#!\t\u0003\u0013i{wnS3fa\u0016\u0014\bbBA\u0017-\u0001\u0007\u0011QD\u0001\nu>|7*Z3qKJDs\u0001AA\u0019\u0003\u0003\n\u0019\u0005\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0015\r\fG/Z4pe&,7O\u0003\u0003\u0002<\u0005%\u0011\u0001D3ya\u0016\u0014\u0018.\\3oi\u0006d\u0017\u0002BA \u0003k\u0011\u0001bQ1uK\u001e|'/_\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003\u000b\u001a#!a\u0012\u0011\t\u0005%\u0013\u0011K\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005!A/Z:u\u0015\r1\u00131E\u0005\u0005\u0003'\nYEA\bJ]R,wM]1uS>tG+Z:u\u0003QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tgB\u0011A\bG\n\u00061\u0005m\u0013\u0011\r\t\u0004\u0001\u0006u\u0013bAA0\u0003\n1\u0011I\\=SK\u001a\u00042\u0001QA2\u0013\r\t)'\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003/\n\u0011DW6DY&,g\u000e^#wK:$H\u000b\u001b:fC\u0012\u0004&/\u001a4jqV\u0011\u0011Q\u000e\t\u0005\u0003_\nI(\u0004\u0002\u0002r)!\u00111OA;\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0014\u0001\u00026bm\u0006L1!`A9\u0003iQ6n\u00117jK:$XI^3oiRC'/Z1e!J,g-\u001b=!\u0003U)h.\u001a=qK\u000e$X\r\u001a+ie\u0016\fGMT1nKN,\"!!!\u0011\r\u0005\r\u0015\u0011RA7\u001b\t\t)IC\u0002\u0002\b\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY)!\"\u0003\u0007M+G/\u0001\fv]\u0016D\b/Z2uK\u0012$\u0006N]3bI:\u000bW.Z:!\u0003)\u0019X\r^+q\u00072\f7o\u001d\u0015\u0004=\u0005M\u0005\u0003BA\u0004\u0003+KA!a&\u0002\n\tY!)\u001a4pe\u0016\u001cE.Y:t\u00035!X-\u0019:E_^t7\t\\1tg\"\u001aq$!(\u0011\t\u0005\u001d\u0011qT\u0005\u0005\u0003C\u000bIA\u0001\u0006BMR,'o\u00117bgN\f\u0011D^3sS\u001aLhj\\+oKb\u0004Xm\u0019;fIRC'/Z1egR\u0019\u0011,a*\t\r\u0005%\u0006\u00051\u0001u\u0003\u001d\u0019wN\u001c;fqR\f1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0016\t\u0005\u0003_\n\t,\u0003\u0003\u00024\u0006E$AB(cU\u0016\u001cG\u000f")
public abstract class ZooKeeperTestHarness
extends JUnitSuite
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests;
    private KafkaZkClient zkClient;
    private AdminZkClient adminZkClient;
    private EmbeddedZookeeper zookeeper;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void verifyNoUnexpectedThreads(String string) {
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads(string);
    }

    @AfterClass
    public static void tearDownClass() {
        ZooKeeperTestHarness$.MODULE$.tearDownClass();
    }

    @BeforeClass
    public static void setUpClass() {
        ZooKeeperTestHarness$.MODULE$.setUpClass();
    }

    public static Set<String> unexpectedThreadNames() {
        return ZooKeeperTestHarness$.MODULE$.unexpectedThreadNames();
    }

    public static String ZkClientEventThreadPrefix() {
        return ZooKeeperTestHarness$.MODULE$.ZkClientEventThreadPrefix();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        ZooKeeperTestHarness zooKeeperTestHarness = this;
        synchronized (zooKeeperTestHarness) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(KafkaZkClient x$1) {
        this.zkClient = x$1;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    public void adminZkClient_$eq(AdminZkClient x$1) {
        this.adminZkClient = x$1;
    }

    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    public int zkPort() {
        return this.zookeeper().port();
    }

    public String zkConnect() {
        return new StringBuilder(10).append("127.0.0.1:").append(this.zkPort()).toString();
    }

    @Before
    public void setUp() {
        this.zookeeper_$eq(new EmbeddedZookeeper());
        this.zkClient_$eq(KafkaZkClient$.MODULE$.apply(this.zkConnect(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSecurityEnabled())), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8()));
        this.adminZkClient_$eq(new AdminZkClient(this.zkClient()));
    }

    @After
    public void tearDown() {
        if (this.zkClient() != null) {
            this.zkClient().close();
        }
        if (this.zookeeper() != null) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zookeeper().shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        }
        Configuration.setConfiguration(null);
    }

    /*
     * WARNING - void declaration
     */
    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        void var3_3;
        Watcher dummyWatcher = new Watcher(null){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assert.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return var3_3;
    }

    public ZooKeeperTestHarness() {
        Logging.$init$((Logging)this);
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
        this.zkMaxInFlightRequests = Integer.MAX_VALUE;
        this.zkClient = null;
        this.adminZkClient = null;
        this.zookeeper = null;
    }
}

