/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.tools.DumpLogSegments$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t4AAD\b\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003BB\u0015\u0001A\u0003%\u0011\u0005C\u0004+\u0001\t\u0007I\u0011\u0001\u0011\t\r-\u0002\u0001\u0015!\u0003\"\u0011\u001da\u0003A1A\u0005\u00025Ba!\u000f\u0001!\u0002\u0013q\u0003b\u0002\u001e\u0001\u0005\u0004%\ta\u000f\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002\u001f\t\u000b\r\u0003A\u0011\u0001#\t\u000bE\u0003A\u0011\u0001#\t\u000bY\u0003A\u0011\u0001#\t\u000bm\u0003A\u0011\u0002/\u0003'\u0011+X\u000e\u001d'pON+w-\\3oiN$Vm\u001d;\u000b\u0005A\t\u0012!\u0002;p_2\u001c(\"\u0001\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005y\u0011A\u0002;na\u0012K'/F\u0001\"!\t\u0011s%D\u0001$\u0015\t!S%\u0001\u0002j_*\ta%\u0001\u0003kCZ\f\u0017B\u0001\u0015$\u0005\u00111\u0015\u000e\\3\u0002\u000fQl\u0007\u000fR5sA\u00051An\\4ESJ\fq\u0001\\8h\t&\u0014\b%A\u0004m_\u001e4\u0015\u000e\\3\u0016\u00039\u0002\"a\f\u001c\u000f\u0005A\"\u0004CA\u0019\u0018\u001b\u0005\u0011$BA\u001a\u0014\u0003\u0019a$o\\8u}%\u0011QgF\u0001\u0007!J,G-\u001a4\n\u0005]B$AB*ue&twM\u0003\u00026/\u0005AAn\\4GS2,\u0007%\u0001\u0003uS6,W#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\n\u0012!B;uS2\u001c\u0018BA!?\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!B:fiV\u0003H#A#\u0011\u0005Y1\u0015BA$\u0018\u0005\u0011)f.\u001b;)\u0005)I\u0005C\u0001&P\u001b\u0005Y%B\u0001'N\u0003\u0015QWO\\5u\u0015\u0005q\u0015aA8sO&\u0011\u0001k\u0013\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D#aC*\u0011\u0005)#\u0016BA+L\u0005\u0015\te\r^3s\u0003A!Xm\u001d;Qe&tG\u000fR1uC2{w\r\u000b\u0002\r1B\u0011!*W\u0005\u00035.\u0013A\u0001V3ti\u0006\u0011\"/\u001e8Ek6\u0004Hj\\4TK\u001elWM\u001c;t)\tqS\fC\u0003_\u001b\u0001\u0007q,\u0001\u0003be\u001e\u001c\bc\u0001\fa]%\u0011\u0011m\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String logFile = new StringBuilder(25).append(this.logDir()).append("/00000000000000000000.log").toString();
    private final MockTime time = new MockTime(0L, 0L);

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String logFile() {
        return this.logFile;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        File x$1 = this.logDir();
        LogConfig x$2 = LogConfig$.MODULE$.apply();
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        Log log = Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.flush();
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testPrintDataLog() {
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--print-data-log", "--files", this.logFile()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFile()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFile()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFile()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFile()}));
        this.verifyNoRecordsInOutput$1((String[])((Object[])new String[]{"--files", this.logFile()}));
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    private final void verifyRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assert.assertTrue((String)new StringBuilder(18).append("Data not printed: ").append(output).toString(), (lines.length > 2 ? 1 : 0) != 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String line = lines[lines.length - 6 + i];
            if (i % 3 == 0) {
                Assert.assertTrue((String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString(), (boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(i / 3 * 2).append(" lastOffset: ").toString()));
            } else {
                Assert.assertTrue((String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString(), (boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RECORD_INDENT()).append(" offset: ").append(i - 1 - i / 3).toString()));
            }
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assert.assertFalse((String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString(), (boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"));
    }
}

